% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_json.R
\name{parse_json_vector}
\alias{parse_json_vector}
\title{Parse a vector of JSON into a list}
\usage{
parse_json_vector(
  x,
  .na = json_na_error(),
  .null = NULL,
  simplifyVector = TRUE,
  simplifyDataFrame = FALSE,
  simplifyMatrix = FALSE,
  flatten = FALSE,
  bigint_as_char = bigint_default(),
  ...
)
}
\arguments{
\item{x}{a scalar JSON character}

\item{.na}{Value to return if \code{x} is \code{NA}. By default an error of class
\code{jsontools_error_na_json} is thrown.}

\item{.null}{Return the prototype of \code{.null} if \code{x} is \code{NULL}
or a zero length character}

\item{simplifyVector}{passed on
to \code{\link[jsonlite:read_json]{jsonlite::parse_json}}.}

\item{simplifyDataFrame}{passed on
to \code{\link[jsonlite:read_json]{jsonlite::parse_json}}.}

\item{simplifyMatrix}{passed on
to \code{\link[jsonlite:read_json]{jsonlite::parse_json}}.}

\item{flatten}{passed on
to \code{\link[jsonlite:read_json]{jsonlite::parse_json}}.}

\item{bigint_as_char}{Parse big integers as character? The option
\code{jsontools.bigint_as_char} is used as default.}

\item{...}{passed on
to \code{\link[jsonlite:read_json]{jsonlite::parse_json}}.}
}
\value{
A list of the same length as \code{x}.
}
\description{
Parse a vector of JSON into a list
}
\examples{
parse_json_vector(x = c('"a"', '"b"'))
parse_json_vector(x = c('"a"', '["b", "c"]'))
parse_json_vector(x = c('"a"', NA), .na = 1)
}
