% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kaplan.R
\name{kaplanModule}
\alias{kaplanModule}
\title{kaplanModule: shiny module server for kaplan-meier plot.}
\usage{
kaplanModule(
  input,
  output,
  session,
  data,
  data_label,
  data_varStruct = NULL,
  nfactor.limit = 10,
  design.survey = NULL,
  id.cluster = NULL,
  timeby = NULL,
  range.x = NULL,
  range.y = NULL
)
}
\arguments{
\item{input}{input}

\item{output}{output}

\item{session}{session}

\item{data}{Reactive data}

\item{data_label}{Reactive data label}

\item{data_varStruct}{Reactive List of variable structure, Default: NULL}

\item{nfactor.limit}{nlevels limit in factor variable, Default: 10}

\item{design.survey}{Reactive survey data. default: NULL}

\item{id.cluster}{Reactive cluster variable if marginal model, Default: NULL}

\item{timeby}{timeby, Default: NULL}

\item{range.x}{range of x axis, Default: NULL}

\item{range.y}{range of y axis, Default: NULL}
}
\value{
Shiny module server for kaplan-meier plot.
}
\description{
Shiny module server for kaplan-meier plot.
}
\details{
Shiny module server for kaplan-meier plot.
}
\examples{
library(shiny)
library(DT)
library(data.table)
library(jstable)
library(ggplot2)
ui <- fluidPage(
  sidebarLayout(
    sidebarPanel(
      kaplanUI("kaplan")
    ),
    mainPanel(
      plotOutput("kaplan_plot"),
      ggplotdownUI("kaplan")
    )
  )
)

server <- function(input, output, session) {
  data <- reactive(mtcars)
  data.label <- reactive(jstable::mk.lev(mtcars))

  out_kaplan <- callModule(kaplanModule, "kaplan",
    data = data, data_label = data.label,
    data_varStruct = NULL
  )

  output$kaplan_plot <- renderPlot({
    print(out_kaplan())
  })
}
}
