% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jstree-shiny.R
\name{jstree-shiny}
\alias{jstree-shiny}
\alias{jstreeOutput}
\alias{renderJstree}
\title{Shiny bindings for jstree}
\usage{
jstreeOutput(outputId, width = "100\%", height = "auto")

renderJstree(expr, env = parent.frame(), quoted = FALSE)
}
\arguments{
\item{outputId}{output variable to read from}

\item{width, height}{must be a valid CSS unit (like \code{'100\%'},
\code{'400px'}, \code{'auto'}) or a number, which will be coerced to a
string and have \code{'px'} appended}

\item{expr}{an expression that generates a \code{\link{jstree}}}

\item{env}{the environment in which to evaluate \code{expr}}

\item{quoted}{logical, whether \code{expr} is a quoted expression
(with \code{quote()}); this is useful if you want to save an expression
in a variable}
}
\value{
\code{jstreeOutput} returns an output element that can be included
  in a Shiny UI definition, and \code{renderJstree} returns a
  \code{shiny.render.function} object that can be included in a Shiny server
  definition.
}
\description{
Output and render functions for using \code{jstree} within
  Shiny applications and interactive Rmd documents. See examples with
  \code{\link{jstreeExample}}.
}
\section{Shiny values}{

  If the \code{outputId} is called \code{"ID"} for example, you have four
  or five available Shiny \code{input} values in the server:
  \code{input[["ID"]]} contains the tree with the node fields \code{text}
  and \code{data} only, \code{input[["ID_full"]]} contains the full tree,
  \code{input[["ID_selected"]]} contains the selected nodes,
  \code{input[["ID_selected_paths"]]} is like \code{input[["ID_selected"]]}
  except that it provides the paths to the selected nodes instead of only
  the values of their text field, and you have a fifth Shiny \code{input}
  value if you have set \code{checkboxes=TRUE} in the \code{\link{jstree}}
  command: \code{input[["ID_selected_tree"]]}, which is like
  \code{input[["ID_selected"]]} except that it preserves the hierarchy, in
  other words it provides the selected nodes with their parent(s).
}

