% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jsTree.R
\name{jsTree}
\alias{jsTree}
\title{Htmlwidget for the jsTree Javascript library}
\usage{
jsTree(obj, tooltips = NULL, nodestate = NULL, ..., width = NULL,
  height = NULL, elementId = NULL)
}
\arguments{
\item{obj}{character, vector of directory tree}

\item{tooltips}{character, named vector of tooltips for elements in the tree, Default: NULL}

\item{nodestate}{boolean, vector the length of obj that initializes tree open to true values, Default: NULL}

\item{...}{parameters that are passed to the vcs package (see details)}

\item{width, height}{Must be a valid CSS unit (like \code{'100\%'},
\code{'400px'}, \code{'auto'}) or a number, which will be coerced to a
string and have \code{'px'} appended.}

\item{elementId}{The input slot that will be used to access the element.}
}
\description{
Htmlwidget for the jsTree Javascript library
}
\details{
parameters in ... that can be passed on to the vcs package are: 
remote_repo a character object that defines the remote user/repository,
remote_branch character object that defines the branch of remote_repo (ussually 'master'),
vcs character object that defines for vcs which version control system to attach (github, bitbucket, svn)
preview.search character object that defines a search term to initialize to in the preview pane searchbox

if remote_repo is given a preview pane of a selected file from the tree will appear to the right of the tree.
preview.search is only relevant for vcs in (github,bitbucket) where file previewing is available

For more information on the vcs package go to \url{https://github.com/metrumresearchgroup/vcs}
}
\examples{
if(interactive()){

data(states)
data(state_bird)

#collapse columns to text (with sep "/")
nested_string <- apply(states,1,paste,collapse='/')
jsTree(nested_string)

# Add tooltips to state names with the state bird 
jsTree(nested_string,tooltips = state_bird)

#initialize tree with checked boxes for certain fields
nodestate1 <- states$variable=='Area'
jsTree(nested_string,nodestate=nodestate1)

nodestate2 <- states$variable=='Area'&grepl('^M',states$state.name)
jsTree(nested_string,nodestate=nodestate2)

nodestate3 <- states$variable \%in\% c('Murder') & states$value >= 10
nodestate4 <- states$variable \%in\% c('HS.Grad') & states$value <= 55
jsTree(nested_string,nodestate=nodestate3|nodestate4)

#change the order of the hierarchy
nested_string2 <- apply(states[,c(4,1,2,3,5)],1,paste,collapse='/')

jsTree(nested_string2)

#use jsTree to visualize folder structure

jsTree(list.files(full.names = TRUE,recursive = FALSE))

\dontrun{
# This may be too long for example if running from ~.
jsTree(list.files(full.names = TRUE,recursive = TRUE))
}
}

}
