% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R, R/write.R
\name{read_jwk}
\alias{read_jwk}
\alias{jwk_read}
\alias{jwk}
\alias{write_jwk}
\alias{jwk_write}
\title{JSON web-keys}
\usage{
read_jwk(file)

write_jwk(x, path = NULL)
}
\arguments{
\item{file}{path to file with key data or literal json string}

\item{x}{an RSA or EC key or pubkey file}

\item{path}{file path to write output}
}
\description{
Read and write RSA, ECDSA or AES keys as JSON web keys.
}
\examples{
# generate an ecdsa key
library(openssl)
key <- ec_keygen("P-521")
write_jwk(key)
write_jwk(as.list(key)$pubkey)

# Same for RSA
key <- rsa_keygen()
write_jwk(key)
write_jwk(as.list(key)$pubkey)
}
