% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{simdat2}
\alias{simdat2}
\title{Simulated joint longitudinal and survival dataset containing 3 studies}
\format{A list of three objects: \describe{ \item{\code{longitudinal}}{A list
  of long format longitudinal datasets one for each of the 3 studies included
  in the dataset.  Each of these datasets contains the following variables:
  \describe{ \item{\code{id}}{long version of the id variable for the data.
  Identical ids between the longitudinal and the survival datasets identify
  the same individual} \item{\code{Y}}{a continuous longitudinal outcome}
  \item{\code{time}}{the longitudinal time variable} \item{\code{study}}{a
  long version of the study membership indicator} \item{\code{intercept}}{a
  long version of the intercept, always takes a value of 1}
  \item{\code{treat}}{a long version of the binary treatment group indicator}
  \item{\code{ltime}}{a duplicate of the longitudinal time variable,
  duplicated as part of the longitudinal data simulation process} }}

  \item{\code{survival}}{A list of survival datasets, one for each of the 5
  studies included in the dataset.  Each of these datasets contains the
  following variables: \describe{ \item{\code{id}}{the id variable for the
  data. Identical ids between the longitudinal and the survival datasets
  identify the same individual} \item{\code{survtime}}{the survival time for
  each individual at which they experienced the event or were censored.  This
  is on the same scale as the longitudinal time measurements.}
  \item{\code{cens}}{censoring indicator for the survival data where 1
  indicates an event and 0 indicates censoring} \item{\code{study}}{study
  membership indicator} \item{\code{treat}}{binary treatment group indicator}
  }}

  \item{\code{percentevent}}{A list of the percentage of events experienced
  in each datasets.  The first element contains the percentage of events
  observed for the first simulated study and so on.} }}
\usage{
simdat2
}
\description{
A simulated dataset containing a single continuous longitudinal outcome and a
single survival outcome, with data available from 3 studies.
}
\details{
This is a simulated dataset generated by subsetting the \code{simdat}
  dataset to leave only three studies with 100 individuals in each study.
  This dataset is for demonstration purposes only within the package.
}
\seealso{
\code{\link{simjointmeta}}
}
\keyword{datasets}
