% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lines.jointdata.R
\name{lines.jointdata}
\alias{lines.jointdata}
\title{Add lines to an existing \code{jointdata} plot}
\usage{
\method{lines}{jointdata}(x, Y.col, ...)
}
\arguments{
\item{x}{object of class \code{jointdata}.}

\item{Y.col}{column number, or column name, of longitudinal variable to be 
plotted. Defaults to \code{Y.col = NA}, plotting all longitudinal
variables.}

\item{...}{other graphical arguments; see \code{\link[graphics]{plot}}.}
}
\value{
A graphical device with a plot for longitudinal data.
}
\description{
Add lines to an existing plot of an object of class \code{jointdata}, for a
longitudinal variable. It is possible to plot all the subjects in the data 
set, or just a selected \code{subset}. See \code{\link{subset.jointdata}}.
}
\examples{

data(heart.valve)
heart.surv <- UniqueVariables(heart.valve, 
                              var.col = c("fuyrs", "status"), 
                              id.col = "num")
heart.long <- heart.valve[, c(1, 4, 5, 7, 8, 9, 10, 11)]
heart.jd <- jointdata(longitudinal = heart.long, 
                      survival = heart.surv,
                      id.col = "num",
                      time.col = "time")
                      
# Randomly select a pair of subjects to plot profiles of
take <- sample(1:max(heart.jd$survival$num), 2)
heart.jd.1 <- subset(heart.jd, take[1])
heart.jd.2 <- subset(heart.jd, take[2])

plot(heart.jd.1, Y.col = 4)
lines(heart.jd.2, Y.col = 4, lty = 2)
}
\author{
Ines Sousa (\email{isousa@math.uminho.pt})
}
\seealso{
Other functions are useful to be used with this such as
  \code{\link{plot}} and \code{\link{points}}.
}
\keyword{aplot}

