% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ttestps.h.R
\name{ttestPS}
\alias{ttestPS}
\title{Paired Samples T-Test}
\usage{
ttestPS(data, pairs, students = TRUE, bf = FALSE, bfPrior = 0.707,
  wilcoxon = FALSE, hypothesis = "different", norm = FALSE,
  meanDiff = FALSE, effectSize = FALSE, ci = FALSE, ciWidth = 95,
  desc = FALSE, plots = FALSE, miss = "perAnalysis")
}
\arguments{
\item{data}{the data as a data frame}

\item{pairs}{a list of lists specifying the pairs of measurement in
\code{data}}

\item{students}{\code{TRUE} (default) or \code{FALSE}, perform Student's
t-tests}

\item{bf}{\code{TRUE} or \code{FALSE} (default), provide Bayes factors}

\item{bfPrior}{a number between 0.5 and 2 (default 0.707), the prior width
to use in calculating Bayes factors}

\item{wilcoxon}{\code{TRUE} or \code{FALSE} (default), perform Wilcoxon
signed rank tests}

\item{hypothesis}{\code{'different'} (default), \code{'oneGreater'} or
\code{'twoGreater'}, the alternative hypothesis; group 1 different to group
2, group 1 greater than group 2, and group 2 greater than group 1
respectively}

\item{norm}{\code{TRUE} or \code{FALSE} (default), perform Shapiro-wilk
normality tests}

\item{meanDiff}{\code{TRUE} or \code{FALSE} (default), provide means and
standard errors}

\item{effectSize}{\code{TRUE} or \code{FALSE} (default), provide effect
sizes}

\item{ci}{\code{TRUE} or \code{FALSE} (default), provide confidence
intervals}

\item{ciWidth}{a number between 50 and 99.9 (default: 95), the width of
confidence intervals}

\item{desc}{\code{TRUE} or \code{FALSE} (default), provide descriptive
statistics}

\item{plots}{\code{TRUE} or \code{FALSE} (default), provide descriptive
plots}

\item{miss}{\code{'perAnalysis'} or \code{'listwise'}, how to handle
missing values; \code{'perAnalysis'} excludes missing values for individual
dependent variables, \code{'listwise'} excludes a row from all analyses if
one of its entries is missing.}
}
\value{
A results object containing:
\tabular{llllll}{
  \code{results$ttest} \tab \tab \tab \tab \tab a table containing the t-test results \cr
  \code{results$norm} \tab \tab \tab \tab \tab a table containing the normality test results \cr
  \code{results$desc} \tab \tab \tab \tab \tab a table containing the descriptives \cr
  \code{results$plots} \tab \tab \tab \tab \tab an array of the descriptive plots \cr
}

Tables can be converted to data frames with \code{asDF} or \code{\link{as.data.frame}}. For example:

\code{results$ttest$asDF}

\code{as.data.frame(results$ttest)}
}
\description{
Paired Samples T-Test
}
\examples{
\dontrun{
data('bugs', package = 'jmv')

ttestPS(bugs, pairs = list(
        list(i1 = 'LDLF', i2 = 'LDHF')))

#
#  PAIRED SAMPLES T-TEST
#
#  Paired Samples T-Test
#  --------------------------------------------------------------
#                                   statistic    df      p
#  --------------------------------------------------------------
#    LDLF    LDHF    Student's t        -6.65    90.0    < .001
#  --------------------------------------------------------------
#
}
}
