
# This file is automatically generated, you probably don't want to edit this

#' @importFrom jmvcore Options
#' @importFrom R6 R6Class
anovaNPOptions <- R6::R6Class(
    "anovaNPOptions",
    inherit = jmvcore::Options,
    public = list(
        initialize = function(
            deps = NULL,
            group = NULL,
            pairs = FALSE, ...) {

            super$initialize(
                package='jmv',
                name='anovaNP',
                requiresData=TRUE,
                ...)
        
            private$..deps <- jmvcore::OptionVariables$new(
                "deps",
                deps,
                suggested=list(
                    "continuous"),
                permitted=list(
                    "continuous",
                    "nominal",
                    "ordinal"))
            private$..group <- jmvcore::OptionVariable$new(
                "group",
                group,
                suggested=list(
                    "nominal",
                    "ordinal"))
            private$..pairs <- jmvcore::OptionBool$new(
                "pairs",
                pairs,
                default=FALSE)
        
            self$.addOption(private$..deps)
            self$.addOption(private$..group)
            self$.addOption(private$..pairs)
        }),
    active = list(
        deps = function() private$..deps$value,
        group = function() private$..group$value,
        pairs = function() private$..pairs$value),
    private = list(
        ..deps = NA,
        ..group = NA,
        ..pairs = NA)
)

#' @import jmvcore
#' @importFrom R6 R6Class
anovaNPResults <- R6::R6Class(
    inherit = jmvcore::Group,
    active = list(
        table = function() private$..table,
        comparisons = function() private$..comparisons),
    private = list(
        ..table = NA,
        ..comparisons = NA),
    public=list(
        initialize=function(options) {
            super$initialize(options=options, name="", title="One-way ANOVA (Non-parametric)")
            private$..table <- jmvcore::Table$new(
                options=options,
                name="table",
                title="Kruskal-Wallis",
                rows="(deps)",
                clearWith=list(
                    "group"),
                columns=list(
                    list(`name`="name", `title`="", `content`="($key)", `type`="text"),
                    list(`name`="chiSq", `title`="\u03C7\u00B2", `type`="number"),
                    list(`name`="df", `title`="df", `type`="integer"),
                    list(`name`="p", `title`="p", `type`="number", `format`="zto,pvalue")))
            private$..comparisons <- jmvcore::Array$new(
                options=options,
                name="comparisons",
                title="Dwass-Steel-Critchlow-Fligner pairwise comparisons",
                items="(deps)",
                visible="(pairs)",
                clearWith=list(
                    "group"),
                template=jmvcore::Table$new(
                    options=options,
                    title="Pairwise comparisons - $key",
                    rows=0,
                    clearWith=NULL,
                    columns=list(
                        list(`name`="p1", `title`="", `content`=".", `type`="text"),
                        list(`name`="p2", `title`="", `content`=".", `type`="text"),
                        list(`name`="W", `type`="number"),
                        list(`name`="p", `title`="p", `type`="number", `format`="zto,pvalue"))))
            self$add(private$..table)
            self$add(private$..comparisons)}))

#' @importFrom jmvcore Analysis
#' @importFrom R6 R6Class
anovaNPBase <- R6::R6Class(
    "anovaNPBase",
    inherit = jmvcore::Analysis,
    public = list(
        initialize = function(options, data=NULL, datasetId="", analysisId="", revision=0) {
            super$initialize(
                package = 'jmv',
                name = 'anovaNP',
                version = c(1,0,0),
                options = options,
                results = anovaNPResults$new(options=options),
                data = data,
                datasetId = datasetId,
                analysisId = analysisId,
                revision = revision,
                pause = NULL)
        }))

#' One Way ANOVA (Non-parametric)
#'
#' Kruskal-Wallis
#'
#' @examples
#' \dontrun{
#' anovaNP(data, deps='len', group='dose')
#' }
#' @param data the data as a data frame
#' @param deps a string naming the dependent variable in \code{data}
#' @param group a string naming the grouping or independent variable in 
#'   \code{data}
#' @param pairs \code{TRUE} or \code{FALSE} (default), perform pairwise 
#'   comparisons 
#' @export
anovaNP <- function(
    data,
    deps,
    group,
    pairs = FALSE) {

    options <- anovaNPOptions$new(
        deps = deps,
        group = group,
        pairs = pairs)

    results <- anovaNPResults$new(
        options = options)

    analysis <- anovaNPClass$new(
        options = options,
        data = data)

    analysis$run()
    analysis$render()

    analysis
}
