#' Just a Rather Bayesian Evidence Synthesis
#'
#' This package was developed with the aim of simplifying the use of meta-analysis
#' models that combine observational and experimental data (e.g. randomized control trials).
#' This package can be useful in "Real-World-Evidence-Synthesis" and "Generalized Evidence
#' Synthesis".
#'
#' The package implements a series of innovative statistical models from the class:
#' Hierarchical Meta-Regression models. This class of models aims to explicitly model
#' the different types of biases that we have to face when we combine evidence of different
#' study types.
#'
#'
#' \tabular{ll}{
#' Package:  \tab jarbes     \cr
#' Type:     \tab Package    \cr
#' Version:  \tab 2.2.1      \cr
#' Date:     \tab 2024-06-06 \cr
#' License:  \tab GPL (>= 2) \cr
#' LazyLoad: \tab yes        \cr }
#'
#' @name jarbes
#' @aliases jarbes
#' @docType package
#'
#' @author PD Dr. Pablo Emilio Verde \email{pabloemilio.verde@hhu.de}
#'
#' @references Verde, P.E, Ohmann, C., Icks, A. and Morbach, S. (2016) Bayesian
#' evidence synthesis and combining randomized and nonrandomized results: a case
#' study in diabetes. Statistics in Medicine. Volume 35, Issue 10, 10 May 2016,
#' Pages: 1654 to 1675.
#'
#' @references Verde, P. E. (2017) Two Examples of Bayesian Evidence Synthesis
#' with the Hierarchical Meta-Regression Approach. Chap.9, pag 189-206.
#' Bayesian Inference, ed. Tejedor, Javier Prieto. InTech.
#'
#' @references Verde, PE. (2019) The hierarchical metaregression approach
#' and learning from clinical evidence. Biometrical Journal. 2019; 61: 535– 557.
#'
#' @references Verde, PE. (2021) A bias-corrected meta-analysis model for combining,
#'  studies of different types and quality. Biometrical Journal. 2021; 63: 406– 422.
#'
#' @references Verde, P.E. and Rosner, G. L. (2024) A Bias-Corrected Bayesian Nonparamteric Model for Combining
#'             Studies with Varying Quality in Meta-Analysis. Biometrical Journal; (under revision).
#'
#'
#' @keywords Hierarchical Modeling, Bayesian Meta-Analysis, Generalized Evidence Synthesis,
#' Conflict of Evidence, Outliers Detection, Multiparameters Meta-Analysis.
#'
