% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jellip.R
\name{jellip}
\alias{jellip}
\title{Jacobi elliptic functions}
\usage{
jellip(kind, u, tau = NULL, m = NULL)
}
\arguments{
\item{kind}{a string with two characters among \code{"s"}, \code{"c"}, 
\code{"d"} and \code{"n"}; this string specifies the function: the two 
letters respectively denote the basic functions \eqn{sn}, \eqn{cn}, 
\eqn{dn} and \eqn{1}, and the string specifies the ratio of two such 
functions, e.g. \eqn{ns = 1/sn} and \eqn{cd = cn/dn}}

\item{u}{a complex number}

\item{tau}{complex number with strictly positive imaginary part; it is 
related to \code{m} and only one of them must be supplied}

\item{m}{the "parameter", square of the elliptic modulus; it is related to 
\code{tau} and only one of them must be supplied}
}
\value{
A complex number.
}
\description{
Evaluation of the Jacobi elliptic functions.
}
\examples{
u <- 2 + 2i
tau <- 1i
jellip("cn", u, tau)^2 + jellip("sn", u, tau)^2 # should be 1
}
