% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_enviro_cor.R
\name{get_enviro_cor}
\alias{get_enviro_cor}
\title{Extract covariances and correlations due to shared environmental responses}
\usage{
get_enviro_cor(mod, type = "mean", prob = 0.95)
}
\arguments{
\item{mod}{An object of class \code{"jSDM"}}

\item{type}{A choice of either the posterior median (\code{type = "median"}) or posterior mean (\code{type = "mean"}), which are then treated as estimates and the fitted values are calculated from.
Default is posterior mean.}

\item{prob}{A numeric scalar in the interval \eqn{(0,1)} giving the target probability coverage of the intervals, by which to determine whether the correlations are "significant".
Defaults to 0.95.}
}
\value{
results A list including : 
\item{cor, cor.lower, cor.upper}{A set of \eqn{np \times np}{np x np} correlation matrices, containing either the posterior median or mean estimate  over the MCMC samples plus lower and upper limits of the corresponding 95 \% highest posterior interval.} 
\item{sig.cor}{A \eqn{np \times np}{np x np} correlation matrix containing only the “significant" correlations whose 95 \% highest posterior interval does not contain zero. All non-significant correlations are set to zero.}
\item{cov}{Average over the MCMC samples of the \eqn{np \times np}{np x np} covariance matrix.}
}
\description{
Calculates the correlation between columns of the response matrix, due to similarities in the response to explanatory variables i.e., shared environmental response.
}
\details{
In both independent response and correlated response models, where the each of the columns of the response matrix y are fitted to a set of explanatory variables given by X,
the covariance and thus between two columns \eqn{j} and \eqn{j'} due to similarities in their response to the model matrix is calculated based on the linear predictors \eqn{X \beta_j} and \eqn{X \beta_j'}, where \eqn{\beta_j} are species effects relating to the explanatory variables.
Such correlation matrices are discussed and found in Ovaskainen et al., (2010), Pollock et al., 2014
}
\examples{
library(jSDM)
# frogs data
 data(frogs, package="jSDM")
 # Arranging data
 PA_frogs <- frogs[,4:12]
 # Normalized continuous variables
 Env_frogs <- cbind(scale(frogs[,1]),frogs[,2],scale(frogs[,3]))
 colnames(Env_frogs) <- colnames(frogs[,1:3])
 Env_frogs <- as.data.frame(Env_frogs)
 # Parameter inference
# Increase the number of iterations to reach MCMC convergence
mod <- jSDM_binomial_probit(# Response variable
                             presence_data=PA_frogs,
                             # Explanatory variables
                             site_formula = ~.,
                             site_data = Env_frogs,
                             n_latent=0,
                             site_effect="random",
                             # Chains
                             burnin=100,
                             mcmc=100,
                             thin=1,
                             # Starting values
                             alpha_start=0,
                             beta_start=0,
                             V_alpha=1,
                             # Priors
                             shape=0.5, rate=0.0005,
                             mu_beta=0, V_beta=10,
                             # Various
                             seed=1234, verbose=1)
# Calcul of residual correlation between species 
 enviro.cors <- get_enviro_cor(mod)
}
\references{
\tabular{l}{
Hui FKC (2016). “boral: Bayesian Ordination and Regression Analysis of Multivariate Abundance Data in R.” Methods in Ecology and Evolution, 7, 744–750. \cr 
Ovaskainen et al. (2010). Modeling species co-occurrence by multivariate logistic regression generates new hypotheses on fungal interactions. Ecology, 91, 2514-2521. \cr
Pollock et al. (2014). Understanding co-occurrence by modelling species simultaneously with a Joint Species Distribution Model (JSDM). Methods in Ecology and Evolution, 5, 397-406. \cr }
}
\seealso{
\code{\link[stats]{cov2cor}} \code{\link{get_residual_cor}} \code{\link{jSDM-package}} \code{\link{jSDM_binomial_probit}} \code{\link{jSDM_binomial_logit}}
}
\author{
\tabular{l}{
Ghislain Vieilledent <ghislain.vieilledent@cirad.fr>\cr
Jeanne Clément <jeanne.clement16@laposte.net>\cr }
}
\keyword{stats::cov2cor}
