% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monobound.R
\name{stackA}
\alias{stackA}
\title{Stacking monotonicity constraint matrices and vectors}
\usage{
stackA(A0, A1, sset, monogrid, gstar0, gstar1, m0.dec, m0.inc, m1.dec,
  m1.inc, mte.dec, mte.inc)
}
\arguments{
\item{A0}{the matrix of values from evaluating the MTR for control
observations over the grid generated to perform the audit. This
matrix will be incorporated into the final constraint matrix
for the bounds.}

\item{A1}{the matrix of values from evaluating the MTR for control
observations over the grid generated to perform the audit. This
matrix will be incorporated into the final constraint matrix
for the bounds.}

\item{sset}{a list containing the point estimates and gamma
components associated with each element in the S-set.}

\item{monogrid}{a list containing the grid over which the
monotonicity and boundedness conditions are imposed on.}

\item{gstar0}{set of expectations for each terms of the MTR for the
control group.}

\item{gstar1}{set of expectations for each terms of the MTR for the
control group.}

\item{m0.dec}{boolean, set to TRUE if MTR for \code{D = 0} should
be monotone decreasing in the unobservable.}

\item{m0.inc}{boolean, set to TRUE if MTR for \code{D = 0} should
be monotone increasing in the unobservable.}

\item{m1.dec}{boolean, set to TRUE if MTR for \code{D = 1} should
be monotone decreasing in the unobservable.}

\item{m1.inc}{boolean, set to TRUE if MTR for \code{D = 1} should
be monotone increasing in the unobservable.}

\item{mte.dec}{boolean, set to TRUE if MTE should be monotone
decreasing in the unobservable.}

\item{mte.inc}{boolean, set to TRUE if MTE should be monotone
decreasing in the unobservable.}
}
\value{
a constraint matrix for the LP problem, the associated
    vector of inequalities, and the RHS vector in the inequality
    constraint. The objects pertain only to the monotonicity
    constraints declared by the user.
}
\description{
This function generates the objects in the LP problem associated
with the monotonicity constraints declared by the user. This
function simply stacks the matrices corresponding to the
monotonicity constraints declared by the user. It also stacks the
RHS vector associated with the monotonicity constraints, and stacks
the vector of inequalities. It is called by the wrapper function
\code{genmonoA}.
}
