% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.VariableContribution}
\alias{plot.VariableContribution}
\title{Exhibit variable contribution for target observations.}
\usage{
\method{plot}{VariableContribution}(x, plot_each_obs = FALSE, num_features = 5, ...)
}
\arguments{
\item{x}{(\code{VariableContribution}) The \code{VariableContribution} object to plot.
It could be the return of function \code{\link{variable_contrib}}.}

\item{plot_each_obs}{(\code{logical}) The option of plot type. If \code{TRUE}, it will
plot variable contribution for every observation. Otherwise, it will plot
variable contribution violin plot for all observations.}

\item{num_features}{(\code{integer}) A number of most important features to plot.
Just work if plot_each_obs is \code{TRUE}.}

\item{...}{Not used.}
}
\value{
\code{ggplot2} figure of Variable Contribution.
}
\description{
Use ggplot2 to plot variable contribution for each target
observation separately or summarize the overall variable contribution across
all selected observations.
}
\examples{
\donttest{
# Using a pseudo presence-only occurrence dataset of
# virtual species provided in this package
library(dplyr)
library(sf)
library(stars)
library(itsdm)

# Prepare data
data("occ_virtual_species")
obs_df <- occ_virtual_species \%>\% filter(usage == "train")
eval_df <- occ_virtual_species \%>\% filter(usage == "eval")
x_col <- "x"
y_col <- "y"
obs_col <- "observation"

# Format the observations
obs_train_eval <- format_observation(
  obs_df = obs_df, eval_df = eval_df,
  x_col = x_col, y_col = y_col, obs_col = obs_col,
  obs_type = "presence_only")

env_vars <- system.file(
  'extdata/bioclim_tanzania_10min.tif',
  package = 'itsdm') \%>\% read_stars() \%>\%
  slice('band', c(1, 5, 12, 16))

# With imperfect_presence mode,
mod <- isotree_po(
  obs_mode = "imperfect_presence",
  obs = obs_train_eval$obs,
  obs_ind_eval = obs_train_eval$eval,
  variables = env_vars, ntrees = 20,
  sample_size = 0.8, ndim = 2L,
  seed = 123L, response = FALSE,
  spatial_response = FALSE,
  check_variable = FALSE)

var_contribution <- variable_contrib(
  model = mod$model,
  var_occ = mod$vars_train,
  var_occ_analysis = mod$vars_train \%>\% slice(1:10))

# Plot variable contribution to each observation
plot(var_contribution,
     plot_each_obs = TRUE,
     num_features = 3)

# Plot the summarized contribution
plot(var_contribution)
}

}
\seealso{
\code{\link{variable_contrib}}
}
