% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variable_contrib.R
\name{variable_contrib}
\alias{variable_contrib}
\title{Evaluate variable contributions for targeted observations.}
\usage{
variable_contrib(
  model,
  var_occ,
  var_occ_analysis,
  shap_nsim = 100,
  visualize = FALSE,
  seed = 10,
  pfun = .pfun_shap
)
}
\arguments{
\item{model}{(\code{isolation_forest} or other model) The SDM.
It could be the item \code{model} of \code{POIsotree} made by function \code{\link{isotree_po}}.
It also could be other user-fitted models as long as the \code{pfun} can work on it.}

\item{var_occ}{(\code{data.frame}, \code{tibble}) The \code{data.frame} style table that
include values of environmental variables at occurrence locations.}

\item{var_occ_analysis}{(\code{data.frame}, \code{tibble}) The \code{data.frame} style table that
include values of environmental variables at occurrence locations for analysis. It
could be either \code{var_occ} or its subset, or any new dataset.}

\item{shap_nsim}{(\code{integer}) The number of Monte Carlo repetitions in SHAP
method to use for estimating each Shapley value. See details in documentation of
function \code{\link{explain}} in package \code{fastshap}.}

\item{visualize}{(\code{logical}) if \code{TRUE}, plot the response curves.
The default is \code{FALSE}.}

\item{seed}{(\code{integer}) The seed for any random progress. The default is \code{10L}.}

\item{pfun}{(\code{function}) The predict function that requires two arguments,
\code{object} and \code{newdata}.
It is only required when \code{model} is not \code{isolation_forest}.
The default is the wrapper function designed for iForest model in \code{itsdm}.}
}
\value{
(\code{VariableContribution}) A list of
\itemize{
\item{shapley_values (\code{data.frame}) A table of Shapley values of each variables for
all observations}
\item{feature_values (\code{tibble}) A table of values of each variables for all
observations}}
}
\description{
Evaluate variable contribution for targeted observations according
to SHapley Additive exPlanations (SHAP).
}
\examples{

# Using a pseudo presence-only occurrence dataset of
# virtual species provided in this package
library(dplyr)
library(sf)
library(stars)
library(itsdm)

# Prepare data
data("occ_virtual_species")
obs_df <- occ_virtual_species \%>\% filter(usage == "train")
eval_df <- occ_virtual_species \%>\% filter(usage == "eval")
x_col <- "x"
y_col <- "y"
obs_col <- "observation"

# Format the observations
obs_train_eval <- format_observation(
  obs_df = obs_df, eval_df = eval_df,
  x_col = x_col, y_col = y_col, obs_col = obs_col,
  obs_type = "presence_only")

env_vars <- system.file(
  'extdata/bioclim_tanzania_10min.tif',
  package = 'itsdm') \%>\% read_stars() \%>\%
  slice('band', c(1, 5, 12))

# With imperfect_presence mode,
mod <- isotree_po(
  obs_mode = "imperfect_presence",
  obs = obs_train_eval$obs,
  obs_ind_eval = obs_train_eval$eval,
  variables = env_vars, ntrees = 5,
  sample_size = 0.8, ndim = 1L,
  seed = 123L, response = FALSE,
  spatial_response = FALSE,
  check_variable = FALSE)

var_contribution <- variable_contrib(
  model = mod$model,
  var_occ = mod$vars_train,
  var_occ_analysis = mod$vars_train \%>\% slice(1:2))
\dontrun{
plot(var_contribution,
  num_features = 3,
  plot_each_obs = TRUE)

# Plot together
plot(var_contribution)
}

}
\references{
\itemize{
\item{\href{https://github.com/bgreenwell/fastshap}{https://github.com/
bgreenwell/fastshap}}
\item{\href{https://github.com/slundberg/shap}{https://github.com/slundberg/shap}}
}
}
\seealso{
\code{\link{plot.VariableContribution}}
\code{\link{explain}} in \code{fastshap}
}
