% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probability.R
\name{probability}
\alias{probability}
\title{Estimate suitability on stars object using trained \code{isolation.forest} model.}
\usage{
probability(x, vars, offset = 0)
}
\arguments{
\item{x}{(\code{isolation_forest}). It could
be the item \code{model} of \code{POIsotree} made by function \code{\link{isotree_po}}.}

\item{vars}{(\code{stars}) The stack of environmental variables. More specifically,
make sure it has x and y dimensions only, and distribute variables to
attributes of this \code{stars}. Otherwise, the function would stop.}

\item{offset}{(\code{numeric}) The offset to adjust fitted suitability. The default
is zero. Highly recommend to leave it as default.}
}
\value{
a \code{stars} of predicted habitat suitability
}
\description{
Apply an \code{isolation.forest} model on a stars object to calculate
environmental suitability and do quantile stretch to \verb{[0, 1]}.
}
\examples{
\dontrun{
# Using a pseudo presence-only occurrence dataset of
# virtual species provided in this package
library(dplyr)
library(sf)
library(stars)
library(itsdm)

# Prepare data
data("occ_virtual_species")
occ_virtual_species <- occ_virtual_species \%>\%
  mutate(id = row_number())

set.seed(11)
occ <- occ_virtual_species \%>\% sample_frac(0.7)
occ_test <- occ_virtual_species \%>\% filter(! id \%in\% occ$id)
occ <- occ \%>\% select(-id)
occ_test <- occ_test \%>\% select(-id)

env_vars <- system.file(
  'extdata/bioclim_tanzania_10min.tif',
  package = 'itsdm') \%>\% read_stars() \%>\%
  slice('band', c(1, 5, 12, 16))

# Modeling
mod_virtual_species <- isotree_po(occ = occ, occ_test = occ_test,
  variables = env_vars, ntrees = 50, sample_size = 0.8, ndim = 2L,
  seed = 123L)
suit <- probability(mod_virtual_species$model,
  mod_virtual_species$variables)
}

}
\seealso{
\code{\link{isotree_po}}
}
