% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{errorBars}
\alias{errorBars}
\title{Add error bars to a plot.}
\usage{
errorBars(x, mean, ci, ci.l = NULL, minmax = NULL, horiz = FALSE, ...)
}
\arguments{
\item{x}{Vector with x-values (or y-values in case \code{horiz=TRUE}).}

\item{mean}{Vector with means.}

\item{ci}{Vector with errors or confidence bands, e.g. SE values. If 
\code{ci.l} is not defined, the errors are assumed to be symmetric. If 
\code{ci.l} is defined, than \code{ci} is assumed to be the upper 
confidence band. Note that the \code{ci} will be added (or substracted) 
from the mean.}

\item{ci.l}{Optional: vector with error to calculate lower confidence band.}

\item{minmax}{Optional argument, vector with two values indicating the 
minimum and maximum value for the error bars. If NULL (default) the error 
bars are not corrected.}

\item{horiz}{Logical: whether or not to plot horizontal error bars. 
Defaults to FALSE (plotting vertical error bars).}

\item{...}{Optional graphical parameters (see \code{\link[graphics]{par}}).}
}
\description{
Add vertical error bars.
}
\examples{
data(simdat)
subj.dat <- with(simdat, 
    aggregate(Y, list(Group=Group, Condition=Condition, Subject=Subject), 
    mean))
avg <- with(subj.dat, tapply(x, list(Group, Condition), mean))
ses  <- with(subj.dat, tapply(x, list(Group, Condition), se))

# barplot:
b <- barplot(avg, beside=TRUE, col=c("gray", "forestgreen"),
    main="Average Y", xlab="Condition",
    legend.text=c("Adults", "Children"), args.legend=list(x="topleft"))
errorBars(b, avg, 1.96*ses, xpd=TRUE, length=.05)

# line plot:
miny  <- with(subj.dat, tapply(x, list(Group, Condition), min))
maxy  <- with(subj.dat, tapply(x, list(Group, Condition), max))
emptyPlot(c(-1,4), range(avg), 
    main="Average Y", xlab="Condition")
group <- "Children"
errorBars(-1:4, avg[group,], maxy[group,], miny[group,], length=.05, 
    col="forestgreen", lwd=2)
points(-1:4, avg[group,], pch=21, type='o', lty=3, lwd=2,
    col="forestgreen", bg="white", xpd=TRUE)
# also horizontal bars possible:
errorBars(10, 1, 1.2, horiz=TRUE)

}
\author{
Jacolien van Rij
}
\seealso{
Other Functions for plotting: \code{\link{addInterval}},
  \code{\link{add_bars}}, \code{\link{alphaPalette}},
  \code{\link{alpha}}, \code{\link{check_normaldist}},
  \code{\link{color_contour}}, \code{\link{dotplot_error}},
  \code{\link{drawArrows}}, \code{\link{emptyPlot}},
  \code{\link{fadeRug}}, \code{\link{fill_area}},
  \code{\link{getCoords}}, \code{\link{getFigCoords}},
  \code{\link{getProps}}, \code{\link{gradientLegend}},
  \code{\link{marginDensityPlot}},
  \code{\link{plot_error}}, \code{\link{plot_image}},
  \code{\link{plotsurface}}, \code{\link{rug_model}}
}

