% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{alphaPalette}
\alias{alphaPalette}
\title{Manipulate the transparency in a palette.}
\usage{
alphaPalette(x, f.seq, n = NULL)
}
\arguments{
\item{x}{A vector with color values. Could be a single value specifying a 
single color palette, ranging in transparency values, or a vector with 
different colors.}

\item{f.seq}{A vector with transparency values, ranging from 0 to 1.}

\item{n}{Optional argument. A number specifying the number of colors in the 
palette. If \code{n} > 1, then N transparency values are generated ranging  
from the minimum of \code{f.seq} to the maximum of \code{f.seq}. \code{n} 
will only be used when the vector \code{f.seq} has two elements or more.}
}
\value{
A vector with color values.
}
\description{
Generate an color palette with changing transparency.
}
\section{Warning}{

On Linux \code{\link{x11}} devices may not support transparency. 
In that case, a solution might be to write the plots immediately to a file 
using functions such as \code{\link{pdf}}, or \code{\link{png}}.
}
\examples{
# a palette of 5 white transparent colors:
alphaPalette('white', f.seq=1:5/5)
# the same palette:
alphaPalette('white', f.seq=c(.2,1), n=5)
# a palette with 10 colors blue, yellow and red, that differ in transparency
alphaPalette(c('blue', "yellow", "red"), f.seq=c(0.1,.8), n=10)

}
\author{
Jacolien van Rij
}
\seealso{
\code{\link[grDevices]{palette}}, \code{\link[grDevices]{colorRampPalette}},
\code{\link[grDevices]{adjustcolor}}, \code{\link[grDevices]{convertColor}}

Other Functions for plotting: \code{\link{addInterval}},
  \code{\link{add_bars}}, \code{\link{alpha}},
  \code{\link{check_normaldist}},
  \code{\link{color_contour}}, \code{\link{dotplot_error}},
  \code{\link{drawArrows}}, \code{\link{emptyPlot}},
  \code{\link{errorBars}}, \code{\link{fadeRug}},
  \code{\link{fill_area}}, \code{\link{getCoords}},
  \code{\link{getFigCoords}}, \code{\link{getProps}},
  \code{\link{gradientLegend}},
  \code{\link{marginDensityPlot}},
  \code{\link{plot_error}}, \code{\link{plot_image}},
  \code{\link{plotsurface}}, \code{\link{rug_model}}
}

