% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user.R
\name{create_unit}
\alias{create_unit}
\title{Create itol.unit}
\usage{
create_unit(
  data,
  key,
  type,
  style = "default",
  subtype = NULL,
  color = NULL,
  line_type = NULL,
  font_type = NULL,
  size_factor = NULL,
  position = NULL,
  background_color = NULL,
  rotation = NULL,
  method = NULL,
  shape = NULL,
  fill = NULL,
  tree
)
}
\arguments{
\item{data}{if type == "COLLAPSE", a vector of characters specifying the tips
or node used for collapsing used for extracting.}

\item{key}{a character specifying the theme name and prefix of data name as
key information for the following reproducible workflow.}

\item{type}{a character specifying the template type used for extracting.
Following choices are possible: "COLLAPSE","PRUNE","SPACING","TREE_COLORS",
"DATASET_STYLE","LABELS","DATASET_TEXT","DATASET_COLORSTRIP",
"DATASET_BINARY","DATASET_GRADIENT","DATASET_HEATMAP","DATASET_SYMBOL",
"DATASET_EXTERNALSHAPE","DATASET_DOMAINS","DATASET_SIMPLEBAR",
"DATASET_MULTIBAR","DATASET_BOXPLOT","DATASET_LINECHART","DATASET_PIECHART",
"DATASET_ALIGNMENT","DATASET_CONNECTION","DATASET_IMAGE","POPUP_INFO.}

\item{style}{a character specifying the specific version of template type
used for extracting. The default value is "default" style for all types.}

\item{subtype}{a character specifying the subtype under type. If the type is
"TREE_COLORS", the following choices are possible: "range", "clade",
"branch", "label", "label_background".}

\item{color}{a character specifying the color pattern name. The following
choices are possible: "table2itol", "RColorBrewer", "ggsci".}

\item{line_type}{a character specifying the normal or dashed line type used
in clade and branch subtype.}

\item{font_type}{a character specifying the bold, italic, and bold-italic
font type used in label and branch subtype.}

\item{size_factor}{a number specifying the line width used in clade and
branch subtype and size factor in label subtype.}

\item{position}{If type == "DATASET_STYLE", a character
specifying the position: The following choices are possible: "node" and
"clade". If type == "DATASET_TEXT", a number specifying the position of the
text on the tree: -1 = external label; a number between 0 and 1 = internal
label positioned at the specified value along the node branch (for example,
position 0 is exactly at the start of node branch, position 0.5 is in the
middle, and position 1 is at the end)}

\item{background_color}{Only used while type == "DATASET_STYLE" and subtype
== "label". a character or a vector of character specifying the background
color in hexadecimal, RGB or RGBA notation.}

\item{rotation}{Only used while type == "DATASET_TEXT". a number or a
vector of number specifying the rotation angle of the text.}

\item{method}{a character specifying the numbric data summarise method. If
type == "DATASET_BINARY", the following choices are possible: "mean",
"sum".}

\item{shape}{a character or a vector of character specifying the symbol
shape. If type == "DATASET_BINARY", the default is 2. If type ==
"DATASET_SYMBOL", the following choices are possible: 1 for rectangle, 2
for circle, 3 for star, 4 for left pointing triangle, 5 for right pointing
triangle. If using NULL and there are data column, the functions will
automaticly help users to setup the shapes based on the levels of the
data.}

\item{fill}{If type == "DATASET_SYMBOL", 1/0 is specifying the shape
outlier filled or not. If type == "DATASET_DOMAINS", the following choices
are possible: "RE|HH|HV|EL|DI|TR|TL|PL|PR|PU|PD|OC|GP".}

\item{tree}{a character specifying Newick format tree file path or a phylo
object of main phylogenetic tree.}
}
\value{
a itol.unit object containing

\item{type}{This group holds information about the template type of
the data only. This is a very critical piece of information. In many
functions of the itol.toolkit package, the template type information is
used to determine the different data processing and input/output methods.}

\item{sep}{This group holds data separator information only.
This is one of the most important parameters for data reading and output.
It is a separate category because it is frequently used and is an input
parameter for other subsequent parameters to be read.}

\item{profile}{This group contains basic information about the
dataset, such as the dataset name and a color label to distinguish the
dataset. The dataset name is extremely important. This parameter is used
almost throughout the data processing of the itol.toolkit package.
With the content of this parameter as the key value, the data and theme
information of the dataset are associated. In turn, high throughput
learning and writing of large-scale data can be achieved. This parameter
is not included in some template types with a particularly simple structure,
so we choose a file name or a user-defined method as the key value.}

\item{field}{This group contains information about each sample
within the dataset, and this type of parameter exists only for multi-sample
data. This information even includes the clustering tree between samples.
This information is usually stored as part of the column names in the
metadata part or abundance information of the itol.hub object.}

\item{common_themes}{These themes are used at high frequency in
different templates. These parameters are small in number but constitute some
common features of iTOL visual style settings, such as legend, margin, etc.}

\item{specific_themes}{These themes are used only in specific
templates. The number of these parameters is very large. However, most of
them are used in only one template to control the style details of the
visualization. By unifying these parameters and calling them according to the
template type, users can perform secondary development and data processing
with a high degree of parameter aggregation without worrying too much about
the differences between different template types.}

\item{data}{This slot contains a list of two data frames with the
nodes and tips data separately. The first column of the two data frames is
the node or tip id. If the input data contains range id, it would be
converted to node id by the convert_range_to_node function automatically.}
}
\description{
Create itol.unit from simple input in R environment.
}
\examples{
tree <- system.file("extdata","tree_of_itol_templates.tree",package = "itol.toolkit")
data("template_groups")
data("template_parameters_count")
# COLLAPSE
group_names <- unique(template_groups$group)
object <- create_hub(tree = tree)
unit <- create_unit(data = group_names, key = "E001_collapse_1",
type = "COLLAPSE", tree = tree)
object <- learn_data_from_unit(object,unit)
# PRUNE
select_note = c("theme_style","basic_plot")
unit <- create_unit(data = select_note, key = "E002_prune_1",
type = "PRUNE", tree = tree)
object <- learn_data_from_unit(object,unit)
# SPACING
df_values = data.frame(id = row.names(template_parameters_count),
values = rowSums(template_parameters_count))
unit <- create_unit(data = df_values, key = "E005_spacing_1",
type = "SPACING", tree = tree)
object <- learn_data_from_unit(object,unit)
# TREE_COLORS
## range
unit <- create_unit(data = template_groups,
key = "E006_tree_colors_1", type = "TREE_COLORS", subtype = "range",
tree = tree)
object <- learn_data_from_unit(object,unit)
}
