% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/ternary_title.R
\docType{methods}
\name{ternary_title}
\alias{ternary_title}
\title{Ternary Plot Annotation}
\usage{
ternary_title(
  main = NULL,
  sub = NULL,
  xlab = NULL,
  ylab = NULL,
  zlab = NULL,
  line = NA,
  outer = FALSE,
  ...
)
}
\arguments{
\item{main}{A \code{\link{character}} string specifying the main title (on top).}

\item{sub}{A \code{\link{character}} string specifying the sub-title (at bottom).}

\item{xlab, ylab, zlab}{A \code{\link{character}} string giving a label for the x, y and
z axes.}

\item{line}{Specifying a value for \code{line} overrides the default placement of
labels, and places them this many lines outwards from the plot edge.}

\item{outer}{A \code{\link{logical}} scalar: should the titles be placed in the outer
margins of the plot?}

\item{...}{Other \link[graphics:par]{graphical parameters} may also be passed as
arguments to this function, particularly, \code{font.main}, \code{cex.main},
\code{col.main} and \code{font.sub}, \code{cex.sub}, \code{col.sub} for title annotation;
\code{font.lab}, \code{cex.lab} and \code{col.lab} for axis label.}
}
\value{
\code{ternary_title()} is called it for its side-effects.
}
\description{
Ternary Plot Annotation
}
\examples{
## Add title
ternary_plot(NULL, main = "Main title", sub = "Subtitle",
             xlab = "A", ylab = "B", zlab = "C")

ternary_plot(NULL, ann = FALSE)
ternary_title(main = "Main title", sub = "Subtitle",
              xlab = "A", ylab = "B", zlab = "C")
}
\seealso{
Other graphical elements: 
\code{\link{ternary_axis}()},
\code{\link{ternary_box}()},
\code{\link{ternary_grid}()},
\code{\link{ternary_pairs}()},
\code{\link{ternary_plot}()}
}
\author{
N. Frerebeau
}
\concept{graphical elements}
