% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blocks_functions.R
\name{orbi_segment_blocks}
\alias{orbi_segment_blocks}
\title{Segment data blocks}
\usage{
orbi_segment_blocks(
  dataset,
  into_segments = NULL,
  by_scans = NULL,
  by_time_interval = NULL
)
}
\arguments{
\item{dataset}{tibble produced by \code{\link[=orbi_define_blocks_for_dual_inlet]{orbi_define_blocks_for_dual_inlet()}}}

\item{into_segments}{segment each data block into this many segments. The result will have exactly this number of segments for each data block except for if there are more segments requested than observations in a group (in which case each observation will be one segment)}

\item{by_scans}{segment each data block into segments spanning this number of scans. The result will be approximately the requested number of scans per segment, depending on what is the most sensible distribution of the data. For example, in a hypothetical data block with 31 scans, if by_scans = 10, this function will create 3 segments with 11, 10 and 10 scans each (most evenly distributed), instead of 4 segments with 10, 10, 10, 1 (less evenly distributed).}

\item{by_time_interval}{segment each data block into segments spanning this time interval. The result will have the requested time interval for all segments except usually the last one which is almost always shorter than the requested interval.}
}
\description{
This step is optional and is intended to make it easy to explore the data within a sample or ref data block. Note that any raw data not identified with \code{data_type} set to "data" (\code{orbi_get_settings("data_type")}) will stay unsegmented. This includes raw data flagged as "startup", "changeover", and "unused".
}
