% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_functions.R
\name{orbi_plot_raw_data}
\alias{orbi_plot_raw_data}
\title{Visualize raw data}
\usage{
orbi_plot_raw_data(
  dataset,
  isotopocules = c(),
  x = c("time.min", "scan.no"),
  x_breaks = scales::breaks_pretty(5),
  y,
  y_scale = c("raw", "linear", "pseudo-log", "log"),
  y_scale_sci_labels = TRUE,
  color = .data$isotopocule,
  colors = c("#1B9E77", "#D95F02", "#7570B3", "#E7298A", "#66A61E", "#E6AB02", "#A6761D",
    "#666666"),
  color_scale = scale_color_manual(values = colors),
  add_data_blocks = TRUE,
  add_all_blocks = FALSE,
  show_outliers = TRUE
)
}
\arguments{
\item{dataset}{isox dataset}

\item{isotopocules}{which isotopocules to visualize, if none provided will visualize all (this may take a long time or even crash your R session if there are too many isotopocules in the data set)}

\item{x}{x-axis column for the plot, either "time.min" or "scan.no"}

\item{x_breaks}{what breaks to use for the x axis, change to make more specifid tickmarks}

\item{y}{expression for what to plot on the y-axis, e.g. \code{intensity}, \code{tic * it.ms} (pick one \code{isotopocules} as this is identical for different istopocules), \code{ratio}. Depending on the variable, you may want to adjust the \code{y_scale} and potentially \code{y_scale_sci_labels} argument.}

\item{y_scale}{what type of y scale to use: "log" scale, "pseudo-log" scale (smoothly transitions to linear scale around 0), "linear" scale, or "raw" (if you want to add a y scale to the plot manually instead)}

\item{y_scale_sci_labels}{whether to render numbers with scientific exponential notation}

\item{color}{expression for what to use for the color aesthetic, default is isotopocule}

\item{colors}{which colors to use, by default a color-blind friendly color palettes (RColorBrewer, dark2)}

\item{color_scale}{use this parameter to replace the entire color scale rather than just the \code{colors}}

\item{add_data_blocks}{add highlight for data blocks if there are any block definitions in the dataset (uses \code{orbi_add_blocks_to_plot()}). To add blocks manually, set \code{add_data_blocks = FALSE} and manually call the \code{orbi_add_blocks_to_plot()} function afterwards.}

\item{add_all_blocks}{add highlight for all blocks, not just data blocks (equivalent to the \code{data_only = FALSE} argument in \code{orbi_add_blocks_to_plot()})}

\item{show_outliers}{whether to highlight data previously flagged as outliers by \code{orbi_flag_outliers()}}
}
\value{
a ggplot object
}
\description{
Call this function to visualize orbitrap data vs. time or scan number. The most common uses are \code{orbi_plot_raw_data(y = intensity)}, \code{orbi_plot_raw_data(y = ratio)}, and \code{orbi_plot_raw_data(y = tic * it.ms)}. By default includes all isotopcules that have not been previously identified by \code{orbi_flag_weak_isotopcules()} (if already called on dataset). To narrow down the isotopocules to show, use the \code{isotopocule} parameter.
}
