% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isobxr_solvers.R
\name{ana_slvr}
\alias{ana_slvr}
\title{Analytically solve stable isotope box models}
\usage{
ana_slvr(input_path, to_DIGEST_csv = FALSE, save_run_outputs = FALSE)
}
\arguments{
\item{input_path}{path to the INPUT file containing all commands for the run \cr
(character string, file name structure: \strong{\emph{RUN name + _IN.Rda}})}

\item{to_DIGEST_csv}{edit csv outputs or not (logical) to the RUN DIGEST folder \cr
(logical, default is FALSE)}

\item{save_run_outputs}{\emph{OPTIONAL} \cr
Logical value. \cr
Allows saving all run outputs to directory containing INPUT file. \cr
By default, run outputs are stored in a temporary directory and are erased if not exported. \cr
Default is FALSE.}
}
\value{
The function returns the analytically determined evolution of stable
isotope compositions in all boxes over the run duration as specified in INPUT file. \cr \cr
By default (unless save_run_outputs = TRUE), run outputs are stored in the temporary directory and are not exported. \cr \cr
The outputs of the run are stored in a Rda output file
with the following file name structure: \cr
\strong{\emph{RUN name + _OUT.Rda}}
}
\description{
An analytical solver of the system of ordinary differential
equations (ODES) of stable isotope ratios of element X in all boxes. \cr
Not intended for direct use although possible. \cr
The analytical solver finds the eigenvalues and eigenvectors of the ODES. \cr
Given the initial conditions as specified in IN.Rda file, it determines the
set of analytical solutions that describes the evolution of isotope ratios
in each box over time.
}
\section{Optional csv outputs to the DIGEST folder are as follows}{

\enumerate{
\item OUT data file with initial and final size and delta values in all boxes. \cr
(file name structure: \strong{\emph{out_1_A_OUT + RUN name + .csv}})
\item ODE_SOLNs data file summarizing outputs of the analytical solutions of the ODES  \cr
(eigenvalues, eigenvectors, relaxation times, constants according to initial conditions).  \cr
(file name structure: \strong{\emph{out_2_A_ODE_SOLNs + RUN name + .csv}})
\item evD data file of the evolution with time of the delta values in all boxes.  \cr
(file name structure: \strong{\emph{out_3_A_evD + RUN name + .csv}})
}
}

