% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iso8601todatetime.R
\name{iso8601todatetime}
\alias{iso8601todatetime}
\title{Convert date-time in ISO8601 format into R POSIXct object}
\usage{
iso8601todatetime(x, ndigitsyear = 4L)
}
\arguments{
\item{x}{character vector of date-time objects}

\item{ndigitsyear}{Number of digits used to encode the year. This should be
an integer with values >= 4 with the same length as \code{x} or length one.
When it is a vector with length greater than one, a different value is used
for each element of \code{x}.}
}
\value{
Returns a \code{\link{POSIXct}} object with the same length as \code{x}. The
object additionally has a 'timezone' attribute which is a character vector
with the same length as \code{x}. This vector contains the original time zone
of the ISO8601 date-time.
}
\description{
Convert date-time in ISO8601 format into R POSIXct object
}
\details{
Date-time strings with a time-zone are converted to UTC.  If all date-time
strings have a time zone the returned object will have it's display time zone
set to GMT, otherwise the time zone is set to local time. It is assumed that
date-times without time zone are in local time.

Missing parts of the time are set to 0.
}
\examples{
x <- iso8601todatetime(c("2024-01-01T12:30", "2024-W01-1T12:30Z",
  "2024-001T12:30+01"))
x
attr(x, "timezone")

# Examples of full date-times
iso8601todatetime("2019-08-17T16:15:14Z")
iso8601todatetime("2019-08-17T161514Z")
iso8601todatetime("2019-08-17T16:15Z")
iso8601todatetime("2019-08-17T1615")
iso8601todatetime("2019-08-17T16Z")
iso8601todatetime("+002019-08-17T16:15:14Z", ndigitsyear = 6)

# Fractional times
iso8601todatetime("2019-08-17T16:15:14,00Z")
iso8601todatetime("2019-08-17T16:15:14.00Z")
iso8601todatetime("2019-08-17T161514.00Z")
iso8601todatetime("2019-08-17T161514,00Z")
iso8601todatetime("2019-08-17T16:15.24Z")
iso8601todatetime("2019-08-17T16:15,24Z")
iso8601todatetime("2019-08-17T1615.24Z")
iso8601todatetime("2019-08-17T1615,24Z")
iso8601todatetime("2019-08-17T16.2539Z")
iso8601todatetime("2019-08-17T16,2539Z")

# When extended format T can be omitted
iso8601todatetime("2019-08-17 16:15:14Z")
iso8601todatetime("2019-08-17 16:15:14,00Z")
iso8601todatetime("2019-08-17 16:15:14.00Z")
iso8601todatetime("2019-08-17 16:15Z")
iso8601todatetime("2019-08-17 16:15Z")
iso8601todatetime("2019-08-17 16:15.24Z")
iso8601todatetime("2019-08-17 16:15,24Z")

# Time zones
iso8601todatetime("2019-08-17T16:15:14Z")
iso8601todatetime("2019-08-17T16:15:14+01:00")
iso8601todatetime("2019-08-17T16:15:14\u00b100:00")
iso8601todatetime("2019-08-17T16:15:14-01")
iso8601todatetime("2019-08-17T16:15:14\u221200:00")
iso8601todatetime("2019-08-17T16:15:14")

}
