% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/density.R
\name{ar1_lpdf}
\alias{ar1_lpdf}
\title{Evaluate the log-density of a stationary Gaussian AR(1) process.}
\usage{
ar1_lpdf(x, times, rho, sigma, mu = 0)
}
\arguments{
\item{x}{A vector of observed values.}

\item{times}{A vector of the time points of observation.}

\item{rho}{A real number strictly less than 1 in absolute value.}

\item{sigma}{A positive real number.}

\item{mu}{A vector of expected values.}
}
\value{
A scalar, the log density.
}
\description{
Evaluate the log-density of a stationary Gaussian AR(1) process, observed at
times \code{times} taking values \code{x}.
}
\examples{
x <- rnorm(5) + 1:5
t <- c(1, 3, 5:6, 10)
rho <- 0.5
sigma <- 1
# zero mean
ar1_lpdf(x, t, rho, sigma)
# means equal times
mu <- t
ar1_lpdf(x + mu, t, rho, sigma, mu)
}
