% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{define_extract_from_json}
\alias{define_extract_from_json}
\title{Create an \code{\link[=ipums_extract-class]{ipums_extract}} object from a JSON-formatted
definition}
\usage{
define_extract_from_json(extract_json)
}
\arguments{
\item{extract_json}{The path to a file containing the JSON definition, or a
JSON string.}
}
\value{
An \code{\link[=ipums_extract-class]{ipums_extract}} object.
}
\description{
Create an \code{\link[=ipums_extract-class]{ipums_extract}} object based on an extract
definition formatted as JSON. For an overview of ipumsr microdata API functionality,
see \code{vignette("ipums-api", package = "ipumsr")}.
}
\examples{
my_extract <- define_extract_usa("Example", "us2013a", "YEAR")

extract_json_path <- file.path(tempdir(), "usa_extract.json")
save_extract_as_json(my_extract, file = extract_json_path)

copy_of_my_extract <- define_extract_from_json(extract_json_path)

identical(my_extract, copy_of_my_extract)

}
\seealso{
Other ipums_api: 
\code{\link{add_to_extract}()},
\code{\link{define_extract_cps}()},
\code{\link{define_extract_usa}()},
\code{\link{download_extract}()},
\code{\link{extract_list_to_tbl}()},
\code{\link{extract_tbl_to_list}()},
\code{\link{get_extract_info}()},
\code{\link{get_last_extract_info}()},
\code{\link{get_recent_extracts_info}},
\code{\link{ipums_data_collections}()},
\code{\link{is_extract_ready}()},
\code{\link{remove_from_extract}()},
\code{\link{save_extract_as_json}()},
\code{\link{set_ipums_api_key}()},
\code{\link{submit_extract}()},
\code{\link{wait_for_extract}()}
}
\concept{ipums_api}
