% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{iana_ports}
\alias{iana_ports}
\title{IANA Service Name and Transport Protocol Port Number Registry}
\format{A data frame with 13,659 rows and 12 variables}
\usage{
data(iana_ports)
}
\description{
This is the dataset of IANA service names and their assigned
ports and transport protocols - along with related metadata.

\itemize{
  \item \code{service_name}: The service name for the port assignment
  \item \code{port_number}: The ports assigned to that service. This can be individual ports, or a range.
  \item \code{transport_protocol}: The transport protocol(s) of the port assignment -
  [\code{dccp}|\code{sctp}|\code{tcp}|\code{udp}]
  \item \code{description}: An explanation of the port assignment
  \item \code{assignee}: the name of the individual or organisation to whom the assignment is made
  \item \code{contact}: the name of the individual or organisation who serves as the contact person for
  the assignment.
  \item \code{registration_date}. The date the assignment was registered on. This may be empty, in the
  case of early assignments; otherwise, it is stored in the form "YYYY-MM".
  \item \code{modification_date}: The date of any modification to the assignment. Same format as
  \code{registration_date}
  \item \code{reference}: A description of (or a reference to a document describing)
  the protocol or application using this port
  \item \code{known_unauthorised_uses}: A list of uses by applications or organizations who are not the assignee
  \item \code{assignment_notes}. Indications of owner/name change, or any other assignment process issue
}
}
\note{
Last updated 2015-05-02
}
\references{
\itemize{
  The \href{http://www.iana.org/assignments/service-names-port-numbers/service-names-port-numbers.xhtml}{IANA list}.
  \href{http://tools.ietf.org/html/rfc6335}{RFC6335}
}
}
\keyword{datasets}

