/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.ibase.toolkit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import org.rosuda.ibase.Common;
import org.rosuda.ibase.toolkit.GraphicsDevice;
import org.rosuda.ibase.toolkit.PlotComponent;
import org.rosuda.ibase.toolkit.PlotJPanel;
import org.rosuda.pograss.PoGraSSgraphics;
import org.rosuda.util.Global;
import org.rosuda.util.Stopwatch;

public class SWINGGraphicsDevice
implements GraphicsDevice {
    Graphics offgc;
    Image[] offscreen = null;
    Dimension offsd = null;
    int layers = 0;
    int updateRoot;
    int prevUpdateRoot = 0;
    private PlotJPanel comp;
    private PlotComponent pcowner;
    boolean inProgress = false;
    Color bgColor = Common.backgroundColor;

    public SWINGGraphicsDevice(int n) {
        this.comp = new PlotJPanel(this);
        this.layers = n;
        this.offscreen = new Image[this.layers];
        for (int i = 0; i < this.layers; ++i) {
            this.offscreen[i] = null;
        }
        this.updateRoot = 0;
        if (Global.DEBUG > 0) {
            System.out.println("SWINGGraphicsDevice: layers=" + this.layers);
        }
    }

    public SWINGGraphicsDevice() {
        this(1);
    }

    public void setUpdateRoot(int n) {
        this.prevUpdateRoot = this.updateRoot;
        this.updateRoot = n;
    }

    public void restoreUpdateRoot() {
        this.updateRoot = this.prevUpdateRoot;
        this.prevUpdateRoot = 0;
    }

    public void paintLayer(Graphics graphics, int n) {
        if (this.pcowner == null) {
            return;
        }
        if (this.inProgress) {
            return;
        }
        this.inProgress = true;
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (Global.forceAntiAliasing) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        PoGraSSgraphics poGraSSgraphics = new PoGraSSgraphics(graphics2D, n);
        this.pcowner.beginPaint(poGraSSgraphics);
        this.pcowner.paintPoGraSS(poGraSSgraphics);
        this.pcowner.endPaint(poGraSSgraphics);
        this.inProgress = false;
    }

    public void paintLayer(int n) {
        this.paintLayer(this.offgc, n);
    }

    public void repaint() {
        this.update(this.comp.getGraphics());
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    public void update(Graphics graphics) {
        int n;
        Object object;
        if (graphics == null) {
            return;
        }
        Dimension dimension = this.comp.getSize();
        int n2 = this.updateRoot;
        if (Global.forceAntiAliasing) {
            object = (Graphics2D)graphics;
            ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (Global.DEBUG > 0) {
            System.out.println("SWINGGraphicsDevice: update, layers=" + this.layers + ", root=" + this.updateRoot);
        }
        if (dimension.width < 1 || dimension.height < 1) {
            return;
        }
        if (dimension.width > 2000 || dimension.height > 2000) {
            dimension.width = dimension.width > 2000 ? 640 : dimension.width;
            dimension.height = dimension.height > 2000 ? 600 : dimension.height;
        }
        object = new Stopwatch();
        if (this.offsd == null || this.offsd.width != dimension.width || this.offsd.height != dimension.height) {
            if (Global.DEBUG > 0) {
                System.out.println("SWINGGraphicsDevice: update, need to re-create offscreen buffers (" + dimension.width + ":" + dimension.height + ")");
            }
            if (this.offscreen[this.layers - 1] != null) {
                graphics.drawImage(this.offscreen[this.layers - 1], 0, 0, this.comp);
            }
            for (n = 0; n < this.layers; ++n) {
                this.offscreen[n] = this.comp.createImage(dimension.width, dimension.height);
            }
            this.offsd = dimension;
            n2 = 0;
            this.setUpdateRoot(0);
            if (Global.PROFILE > 0) {
                ((Stopwatch)object).profile("SWINGGraphicsDevice.update.recreateOffscreen");
            }
        }
        if (n2 == 0) {
            this.offgc = this.offscreen[0].getGraphics();
            if (this.offgc != null) {
                this.offgc.setFont(Common.defaultFont);
                if (Global.forceAntiAliasing) {
                    Graphics2D graphics2D = (Graphics2D)this.offgc;
                    graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                }
                if (Global.useAquaBg) {
                    this.offgc.setColor(Color.white);
                    this.offgc.fillRect(0, 0, dimension.width, dimension.height);
                    this.offgc.setColor(Common.aquaBgColor);
                    for (n = 0; n < dimension.height - 2; n += 4) {
                        this.offgc.fillRect(0, n, dimension.width, 2);
                    }
                } else {
                    Color color = this.bgColor;
                    this.offgc.setColor(color == null ? Color.white : color);
                    this.offgc.fillRect(0, 0, dimension.width, dimension.height);
                }
                Color color = this.comp.getForeground();
                if (this.offgc != null) {
                    this.offgc.setColor(color == null ? Color.black : color);
                }
            }
            if (Global.PROFILE > 0) {
                ((Stopwatch)object).profile("SWINGGraphicsDevice.update.clearLayer0");
            }
        }
        for (n = n2; n < this.layers; ++n) {
            this.offgc = this.offscreen[n].getGraphics();
            if (n > 0) {
                this.offgc.drawImage(this.offscreen[n - 1], 0, 0, this.comp);
            }
            this.paintLayer(this.offgc, n);
        }
        if (Global.PROFILE > 0) {
            ((Stopwatch)object).profile("SWINGGraphicsDevice.update.constructLayers");
        }
        graphics.drawImage(this.offscreen[n - 1], 0, 0, this.comp);
        if (Global.PROFILE > 0) {
            ((Stopwatch)object).profile("SWINGGraphicsDevice.update.paintLayers");
        }
    }

    public void setPCOwner(PlotComponent plotComponent) {
        this.pcowner = plotComponent;
    }

    public int getGrDevID() {
        return 1;
    }

    public Component getComponent() {
        return this.comp;
    }

    public Rectangle getBounds() {
        return this.comp.getBounds();
    }

    public void setSize(int n, int n2) {
        this.setSize(new Dimension(n, n2));
    }

    public Dimension getSize() {
        return this.comp.getSize();
    }

    public void setBackground(Color color) {
        this.bgColor = color;
        this.comp.setBackground(color);
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.comp.addMouseListener(mouseListener);
    }

    public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.comp.addMouseMotionListener(mouseMotionListener);
    }

    public void addKeyListener(KeyListener keyListener) {
        this.comp.addKeyListener(keyListener);
    }

    public Point getLocation() {
        return this.comp.getLocation();
    }

    public void setCursor(Cursor cursor) {
        this.comp.setCursor(cursor);
    }

    public void setSize(Dimension dimension) {
        this.comp.setSize(dimension);
        this.comp.setPreferredSize(dimension);
        this.comp.setMinimumSize(dimension);
    }

    public int getWidth() {
        return this.comp.getWidth();
    }

    public int getHeight() {
        return this.comp.getHeight();
    }

    public Container getParent() {
        return this.comp.getParent();
    }

    public void setToolTipText(String string) {
        this.comp.setToolTipText(string);
    }
}

