% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qtd.R
\encoding{UTF-8}
\name{qtd}
\alias{qtd}
\title{Calcul de la valeur qtd d'une serie.}
\usage{
qtd(data, date, q = 0, x, unite = 1, decimal = 0, cumul = FALSE)
}
\arguments{
\item{data}{Un objet de type data.frame contenant au minimum la serie numerique et un vecteur de type date.}

\item{date}{La date que l'on souhaite connaitre la valeur de la serie.}

\item{q}{Une valeur de type entier qui permet de décaler le trimestre par rapport à la date introduite. Sa valeur par defaut est \code{0}.}

\item{x}{Un vecteur de type numeric contenant les observations du phénomène à etudier.}

\item{unite}{Un valeur de type numeric, definissant l'ordre d'echelle d'affisage du resultat de la fonction. Sa valeur par defaut est \code{1}.}

\item{decimal}{Un objet de type numeric permettant de préciser le nombre d'entier à afficher après la virgule. Sa valeur par defaut est \code{0}.}

\item{cumul}{Un objet de type logic qui permet d'indiquer si le vecteur \code{x} contient des valeurs cumulées. Sa valeur par defaut est \code{FALSE}.}
}
\value{
Un vecteur de longieur 1.
}
\description{
Cette fonction permet de calculer la somme des valeurs d'une série sur un trimestre depuis le 1er jour jusqu’à date introduit par l'utilisateur.
}
\examples{
x <- rnorm(222, mean = 50, sd = 6.3)
date <- seq.Date(as.Date("2023-01-01"), by = "day", len = 222)
df <- data.frame(date, x)
qtd(df, date = "2023-07-06", x = "x")

}
