% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sequence.R
\name{sequence}
\alias{sequence}
\alias{seq.ip_network}
\alias{hosts}
\title{List addresses within a network}
\usage{
\method{seq}{ip_network}(x, ...)

hosts(x)
}
\arguments{
\item{x}{An \code{\link{ip_network}} scalar}

\item{...}{Included for generic consistency}
}
\value{
An \code{\link{ip_address}} vector
}
\description{
\code{seq()} returns \emph{all} hosts

\code{hosts()} returns only \emph{usable} hosts
}
\details{
In IPv4, the unusable hosts are the network address and the broadcast
address (i.e. the first and last addresses in the network).
In IPv6, the only unusable host is the subnet router anycast address
(i.e. the first address in the network).

For networks with a prefix length of 31 (for IPv4) or 127 (for IPv6),
the unusable hosts are included in the results of \code{hosts()}.

The \code{ipaddress} package does not support \link[base:LongVectors]{long vectors}
(i.e. vectors with more than 2^31 - 1 elements). As a result, these two
functions do not support networks larger than this size. This corresponds
to prefix lengths less than 2 (for IPv4) or 98 (for IPv6). However, you
might find that machine memory imposes stricter limitations.
}
\examples{
seq(ip_network("192.168.0.0/30"))

seq(ip_network("2001:db8::/126"))

hosts(ip_network("192.168.0.0/30"))

hosts(ip_network("2001:db8::/126"))
}
\seealso{
Use \code{\link[=network_address]{network_address()}} and \code{\link[=broadcast_address]{broadcast_address()}} to get the first and last
address of a network.

Use \code{\link[=sample_network]{sample_network()}} to randomly sample addresses from a network.
}
