% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iopspackage2.0.R
\name{IOPS}
\alias{IOPS}
\title{IOPS}
\usage{
IOPS(
  CountryCode,
  tradeData,
  ComplexMethod = "eigenvalues",
  iterCompl = 20,
  GVCMapping = NULL,
  tradedigit = 6
)
}
\arguments{
\item{CountryCode}{(Type: character/integer) Any accepted ISO country code could be used, e.g. \code{"United Kingdom"}, \code{"GBR"}, \code{"GB"}, \code{828} would all be accepted if the United Kingdom is the desired country. This version of the package uses country_codes_V202201 from th BACI Hs17 2020 dataset, but can be changed in \code{inst/extdata}.}

\item{tradeData}{(Type: csv) Accepts any CEPII BACI trade data. NOTE: tradeData and GVCMapping must be from the same "H" Family, e.g. both are from  H3, etc., in order for the program to work correctly.}

\item{ComplexMethod}{(Type: character) Methods used to calculate complexity measures. Can be any one of these methods: \code{"fitness"}, \code{"reflections"} or \code{"eigenvalues"}. Defaults to "eigenvalues".}

\item{iterCompl}{(Type: integer) The number of iterations that the chosen complexity measure must use. Defaults to \code{iterCompl = 20}.}

\item{GVCMapping}{(Type: csv) The desired value chain to be analysed. With Columns "Tiers", "Activity", and "HSCode". NOTE: tradeData and GVCMapping must be from the same "H" Family, e.g. both are from  H3, etc., in order for the program to work correctly.}

\item{tradedigit}{(Type: integer) Indicate if the raw trade digit summation should be done on a 6- or 4-digit level. Defaults to tradedigit = 6.}
}
\value{
A list that constrains ECI, PCI, Opportunity_Gain, distance, density, M_absolute, M_binary, Tier_Results, Product_Category_Results, Product_Results, respectively.
}
\description{
Takes user inputted trade data, any acceptable ISO country code and industrial value chain mapping to calculate various metrics (Economic- and Product complexity metrics, distance metrics, opportunity gain, and inequality metrics) of a given country in order to facilitate better decision making regarding industrial policymaking.
}
\examples{

# Create a temporary directory
temp_dir <- tempfile()
dir.create(temp_dir)

# Set the working directory to the temporary directory
old_dir <- setwd(temp_dir)

#Generate example trade data
GeneratedTradeData <- data.frame(
  t = c(2020, 2020, 2020),
  i = c(4, 710, 710),
  j = c(842, 124, 251),
  k = c(842410, 110220, 845210),
  v = c(4.776, 0.088, 0.057),
  q = c(0.025, 0.007, 0.005)
)

# Use your function with generated trade data
IOPS(
  CountryCode = 710,
  tradeData = GeneratedTradeData,
  ComplexMethod = "reflections",
  iterCompl = 2,
  GVCMapping = NULL,
  tradedigit = 6
)

\donttest{
# Use your function with real trade data
IOPS(
  CountryCode = 710,
  tradeData = ExampleTradeData,
  ComplexMethod = "reflections",
  iterCompl = 2,
  GVCMapping = NULL,
  tradedigit = 6
)
}

# Clean up the temporary directory
  setwd(old_dir)  # Restore the original working directory
  unlink(temp_dir, recursive = TRUE)


}
