% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getInvaCostVersion.R
\name{getInvaCostVersion}
\alias{getInvaCostVersion}
\title{Download and read a specific version of 'InvaCost'}
\usage{
getInvaCostVersion(version = "4.1", destination_file = NULL)
}
\arguments{
\item{version}{\code{character} indicating the major release to download.
Current versions include: \code{"1.0"}, \code{"2.0"}, \code{"2.1"}, 
\code{"3.0"}, \code{"4.0"} and \code{"4.1"},}

\item{destination_file}{\code{character} indicating the name of the saved
file}
}
\value{
a \code{data.frame} with dimensions variable depending on the chosen
version.
}
\description{
This function will download the requested major release of 'InvaCost' to
the specified file, then read it into R, such that analyses done on older
releases of the database can be reproduced.
}
\details{
The public archive for 'InvaCost' releases is available here:
\url{https://figshare.com/articles/dataset/InvaCost_References_and_description_of_economic_cost_estimates_associated_with_biological_invasions_worldwide_/12668570}

The files used in this function correspond to official releases by the 
'InvaCost' team and are downloaded in CSV (\code{sep = ";"}) from a dedicated
GitHub repository: \url{https://github.com/Farewe/invacost_versions}
}
\examples{
invacost <- getInvaCostVersion("1.0")
dim(invacost)
}
\references{
\url{https://github.com/Farewe/invacost}

Leroy Boris, Kramer Andrew M, Vaissière Anne-Charlotte, Kourantidou Melina,
Courchamp Franck & Diagne Christophe (2022). Analysing economic costs 
of invasive alien species with the invacost R package. Methods in Ecology
and Evolution. \doi{10.1111/2041-210X.13929}
}
\author{
Boris Leroy \email{leroy.boris@gmail.com}, Andrew Kramer, Anne-Charlotte
Vaissière, Christophe Diagne
}
