% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intensitynet.R
\name{ShortestPathIntensity.intensitynet}
\alias{ShortestPathIntensity.intensitynet}
\title{Calculates the shortest path between two vertices and calculates its intensity}
\usage{
\method{ShortestPathIntensity}{intensitynet}(obj, node_id1, node_id2, weighted = FALSE)
}
\arguments{
\item{obj}{intensitynet object}

\item{node_id1}{starting node}

\item{node_id2}{ending node}

\item{weighted}{TRUE or FALSE (default), tell if the distances must be taken into account}
}
\value{
intensity of the shortest path and the path vertices
}
\description{
Calculates the shortest path between two vertices and calculates its intensity
}
\examples{

data("und_intnet_chicago")
ShortestPathIntensity(und_intnet_chicago, node_id1 = 'V1', node_id2 = 'V300')

}
