% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intcure.r
\name{intcure}
\alias{intcure}
\title{Mixture cure models with random effects}
\usage{
intcure(
  formula = formula(data),
  cureform = NULL,
  data = sys.parent(),
  subset,
  na.action,
  bt = NULL,
  gm = NULL,
  basepara = NULL,
  sigma = c(0, 0, 0),
  optimcfg = list(ndeps = 0.001, maxit = 1000, reltol = 1e-05, method = "Nelder-Mead",
    hessian = FALSE),
  intcfg = list(eps = 1e-04, lower = c(-5, -5), upper = c(5, 5)),
  basedist = c("exponential", "weibull", "piecewise"),
  npiece = 3,
  piececut = NULL,
  piececuttype = c("quantile", "even"),
  model = FALSE,
  y = TRUE,
  x = FALSE,
  z = FALSE,
  funval = FALSE,
  debug = c("intcure", "integration", "optim")
)
}
\arguments{
\item{formula}{a formula expression similar to the one used in \code{survreg}
and \code{coxph}. The response is a survival object returned by the \code{Surv()} function.
It is used to specify the time (and censoring variable) variable and
covariates in the model for uncured patients. A covariate that defines
clusters in data will be in \code{cluster} function. See \code{coxph()} for details
If random effects are specified in \code{sigma} and \code{cluster} is not specified,
every subject forms its own cluster.}

\item{cureform}{a formula expression similar to formula except that
it does not contain a response. It is used to specify the effects
of covariates on the cure rate. A covariate that defines clusters
in data will be in \code{cluster} function as in formula. However, currently
it is not used in the function because we assume that both components
in cure model use the same cluster structure
If random effects are specified in \code{sigma} and \code{cluster} is not specified,
every subject forms its own cluster.}

\item{data, subset, na.action}{standard arguments for R model functions}

\item{bt}{a vector of initial value of beta in the latency model.
It is optional. If \code{survreg} is used to get initial values,
-\code{survreg}'s \code{bt/survreg}'s scale = \code{bt}}

\item{gm}{a vector of initial value of gamma in the incidence model. It is optional}

\item{basepara}{a vector of initial values of the parameters in the baseline
distribution. They are the log rate if baseline = \code{"exponential"}, log shape and
log rate if baseline = \code{"weibull"}, and log hazard if baseline = \code{"piecewise"}.
It is optional. If \code{survreg} is used to get initial values, then
\code{survreg}'s \code{scale = 1/}weibull \code{shape} and
\code{survreg}'s \code{intercept = -log(}weibull \code{rate})/weibull \code{shape}
if basedist = \code{"weibull"}, and \code{survreg}'s \code{intercept = -log(rate)} if
basedist = \code{"exponential"}. Inappropriate initial values can cause
some problems in \code{adaptIntegrate} function.}

\item{sigma}{a vector of 3 corresponding to log standard deviation of u and v,
and a Fisher's z-transformed correlation coefficient of u and v.
If any of the value is set to \code{NA}, the corresponding effects
will not be present in the model}

\item{optimcfg}{a list of \code{method}, \code{maxit}, \code{reltol},
\code{hessian}, \code{ndeps} arguments for R function \code{optim()}.
The default optimization method is Nelder-Mead.}

\item{intcfg}{a list of \code{lower}, \code{upper}, \code{eps} to be passed
onto an R integration function. If one random effect is specified, the built-in R
integration function \code{integrate} is used. If two random effects are
specified,
R function \code{adaptIntegrate} from package \code{cubature} is used to do
the integration.}

\item{basedist}{type of baseline distribution. It can be one of \code{"exponential"},
\code{"weibull"}, or \code{"piecewise"}, where \code{"piecewise"} stands for piecewise constant
hazard distribution. The default is \code{"exponential"}.}

\item{npiece, piececut, piececuttype}{arguments for baseline distribution
when it is piecewise constant hazard distribution. They are respectively
the number of pieces, the cut points to form the pieces and how the pieces
are formed. \code{piececut} should only include the interior time points
and the length of \code{piececut} should be equal to \code{npiece - 1}.
There are two ways to specify the piecewise constant hazard
distribution: specify \code{piececut} or specify \code{npiece} and
\code{piececuttype}. There are two possible types for \code{piececuttype}:
\code{"quantile"} and \code{"even"}. \code{"quantile"} is the default
if not specified.}

\item{model}{if TRUE, output model matrix instead of fitting the model}

\item{y, x, z}{if TRUE, output corresponding matrix in the model matrix}

\item{funval}{a logical value. If TRUE, evaluate the likelihood function at initial values
instead of fitting the model}

\item{debug}{for debug purpose}
}
\value{
an object of class \code{intcure} is returned. It includes all the values
returned from \code{optim()} in addition to the following values:
\item{call}{The call to \code{intcure}}
\item{basedist}{The baseline distribution fitted}
\item{method}{The optimization method used}
\item{n}{Sample size}
}
\description{
Fit mixture cure models with random effects based on numerical integration.
}
\details{
This package depends on \code{cubature} package for numerical
integration and \code{mvtnorm} package. Better initial values for \code{bt},
\code{gm} and \code{basepara} obtained
from a mixture cure model without random effects may help speed up the
program or finding the best estimates.
}
\examples{
data(simdata)
intcure(Surv(time, cens) ~ rx + cluster(id), ~ rx, data = simdata,
basedist = "weibull", sigma = c(-1, NA, NA), optimcfg = list(maxit = 1000))
}
\references{
Peng, Y. and Taylor, J. M. G. Mixture cure model with random effects for the analysis of a multi-centre tonsil cancer study. Statistics in Medicine, 30:211-223, 2011
}
\seealso{
\code{\link{survreg}}, \code{\link{coxph}}, \code{\link{glm}}
}
\author{
Yingwei Peng
}
