% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_get_data.R
\name{construct_model_points}
\alias{construct_model_points}
\title{Construct model points from Generalized Linear Model}
\usage{
construct_model_points(
  x,
  exposure = NULL,
  exposure_by = NULL,
  agg_cols = NULL,
  drop_na = FALSE
)
}
\arguments{
\item{x}{Object of class model_data or of class data.frame}

\item{exposure}{column with exposure}

\item{exposure_by}{split column exposure by (e.g. year)}

\item{agg_cols}{list of columns to aggregate (sum) by, e.g. number of claims}

\item{drop_na}{drop na values (default to FALSE)}
}
\value{
data.frame
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} \code{construct_model_points()}
is used to construct model points from generalized linear models, and must
be preceded by \code{model_data()}. \code{construct_model_points()} can also be used
in combination with a data.frame.
}
\examples{
\dontrun{
# With data.frame
library(dplyr)
mtcars \%>\%
 select(cyl, vs) \%>\%
 construct_model_points()

mtcars \%>\%
  select(cyl, vs, disp) \%>\%
  construct_model_points(exposure = disp)

mtcars \%>\%
 select(cyl, vs, disp, gear) \%>\%
 construct_model_points(exposure = disp, exposure_by = gear)

mtcars \%>\%
 select(cyl, vs, disp, gear, mpg) \%>\%
 construct_model_points(exposure = disp, exposure_by = gear,
   agg_cols = list(mpg))

# With glm
library(datasets)
data1 <- warpbreaks \%>\%
 mutate(jaar = c(rep(2000, 10), rep(2010, 44))) \%>\%
 mutate(exposure = 1) \%>\%
 mutate(nclaims = 2)

pmodel <- glm(breaks ~ wool + tension, data1, offset = log(exposure),
 family = poisson(link = "log"))

model_data(pmodel) \%>\%
 construct_model_points()

model_data(pmodel) \%>\%
 construct_model_points(agg_cols = list(nclaims))

model_data(pmodel) \%>\%
 construct_model_points(exposure = exposure, exposure_by = jaar) \%>\%
 add_prediction(., pmodel)
 }

}
\author{
Martin Haringa
}
