% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_performance.R
\name{model_performance}
\alias{model_performance}
\title{Performance of fitted GLMs}
\usage{
model_performance(...)
}
\arguments{
\item{...}{One or more objects of class \code{glm}.}
}
\value{
data frame
}
\description{
Compute indices of model performance for (one or more) GLMs.
}
\details{
The following indices are computed:
\itemize{
  \item{\strong{AIC}} {Akaike's Information Criterion, see \code{\link[stats]{AIC}}}
  \item{\strong{BIC}} {Bayesian Information Criterion, see \code{\link[stats]{BIC}}}
  \item{\strong{RMSE}} {Root mean squared error, \code{\link{rmse}}}
}

Adopted from \code{performance::model_performance()}.
}
\examples{
m1 <- glm(nclaims ~ area, offset = log(exposure), family = poisson(), data = MTPL2)
m2 <- glm(nclaims ~ area, offset = log(exposure), family = poisson(), data = MTPL2)
model_performance(m1, m2)

}
\author{
Martin Haringa
}
