% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspect_.R
\name{inspect_bfactor_scale}
\alias{inspect_bfactor_scale}
\title{Validate Bayes factor interpretation scales}
\usage{
inspect_bfactor_scale(x)
}
\arguments{
\item{x}{An arbitrary object.}
}
\value{
\code{inspect_bfactor_scale} does not return any output. There are two possible scenarios:
\itemize{
\item The call is silent if \code{x} is a character vector of \code{\link[base]{length}} 1 that is eligible to represent one of the Bayes factor interpretation scales available in the \code{pcal} package.
\item An informative error message is thrown otherwise.
}
}
\description{
\code{inspect_bfactor_scale} checks if an object is a character vector of \code{\link[base]{length}} 1 that is eligible to represent one of the Bayes factor interpretation scales available in the \code{pcal} package. This can be useful to validate inputs in user-defined functions.
}
\details{
\code{inspect_bfactor_scale} conducts a series of tests to check if \code{x} is a character vector of \code{\link[base]{length}} 1 that is eligible to represent one of the Bayes factor interpretation scales available in the \code{pcal} package. Namely, \code{inspect_bfactor_scale} checks if:
\itemize{
\item \code{x} is \code{NULL} or empty.
\item \code{x} is \code{NA} or \code{NaN}.
\item \code{x} is an atomic vector of \code{\link[base]{length}} 1
\item The \code{\link[base]{typeof}} \code{x} is character
\item The value of \code{x} is either "Jeffreys" or "Kass-Raftery" (not case sensitive).
}
}
\examples{
# Calls that pass silently:
x1 <- "Jeffreys"
x2 <- "jeffreys"
x3 <- "kass-raftery"
x4 <- "Kass-Raftery"
inspect_bfactor_scale(x1)
inspect_bfactor_scale(x2)
inspect_bfactor_scale(x3)
inspect_bfactor_scale(x4)

# Calls that throw informative error messages:
mylist <- list(NULL, NA, NaN, 10, "Bayes", "Jeff",
          "kassraftery", c("jeffreys", "kass-raftery"))
try(inspect_bfactor_scale(mylist[[1]]))
try(inspect_bfactor_scale(mylist[[2]]))
try(inspect_bfactor_scale(mylist[[3]]))
try(inspect_bfactor_scale(mylist[[4]]))
try(inspect_bfactor_scale(mylist[[5]]))
try(inspect_bfactor_scale(mylist[[6]]))
try(inspect_bfactor_scale(mylist[[7]]))
try(inspect_bfactor_scale(mylist[[8]]))

}
\seealso{
\itemize{
\item \code{\link[pcal]{bfactor_interpret}} for the interpretation of Bayes factors.
\item \code{\link[pcal]{bfactor_log_interpret}} for the interpretation of the logarithms of Bayes factors.
\item \code{\link[inspector]{inspect_bfactor}} to check if an object is a numeric vector of valid Bayes factor values.
\item \code{\link[inspector]{inspect_bfactor_log}} to check if an object is a numeric vector of valid logarithmic Bayes factor values.
}
}
