% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspect_num.R
\name{inspect_num}
\alias{inspect_num}
\title{Summarise and compare the numeric variables within one or two dataframes}
\usage{
inspect_num(df1, df2 = NULL, show_plot = F, breaks = 20,
  plot_layout = NULL, breakseq = NULL)
}
\arguments{
\item{df1}{A data frame}

\item{df2}{An optional second data frame for comparing categorical levels.
Defaults to \code{NULL}.}

\item{show_plot}{Logical determining whether to show a plot in addition 
to tibble output.  Default is \code{FALSE}.}

\item{breaks}{Optional argument determining how breaks are constructed for 
histograms when comparing numeric data frame features.  This is passed to 
\code{hist(..., breaks)}.  See \code{?hist} for more details.}

\item{plot_layout}{Vector specifying the number of rows and columns 
in the plotting grid.  For example, 3 rows and 2 columns would be specified as 
\code{plot_layout = c(3, 2)}.}

\item{breakseq}{For internal use only.  Argument that accepts a pre-specified set of 
break points, default is \code{NULL}.}
}
\value{
A \code{tibble} containing statistical summaries of the numeric 
columns of \code{df1}, or comparing the histograms of \code{df1} and \code{df2}.
}
\description{
Summarise and compare the numeric variables within one or two dataframes
}
\details{
If only \code{df1} is specified, \code{inspect_num} returns a tibble with columns
\itemize{
  \item \code{col_name} character vector containing the column names in \code{df1}
  and \code{df2}
  \item \code{min}, \code{q1}, \code{median}, \code{mean}, \code{q3}, \code{max} and 
  \code{sd}: the minimum, lower quartile, median, mean, upper quartile, maximum and 
  standard deviation for each numeric column.
  \item \code{pcnt_na} the percentage of each numeric feature that is missing
  \item \code{hist} a list of tibbles containing the relative frequency of values in a 
  set of discrete bins for each column.
}
If both \code{df1} and \code{df2} are specified, the tibble has columns
\itemize{
  \item \code{col_name} character vector containing the column names in \code{df1}
  and \code{df2}
  \item \code{hist_1}, \code{hist_2} list column for histograms of each of \code{df1} and \code{df2}.
  Where a column appears in both dataframe, the bins used for \code{df1} are reused to 
  calculate histograms for \code{df2}.
  \item{psi} numeric column containing the 
  \href{https://www.quora.com/What-is-population-stability-index}{population stability index}.  
  This measures the change in distribution of two numeric features.  Conventionally, values
  exceeding 0.25 indicate strong evidence of a change, with values below 0.25 and 0.1 
  representing moderate and low evidence of a change.
  \item{fisher_p} p-value corresponding to Fisher's exact test.  A small p indicates 
  evidence that the the two histograms are actually different.
}
}
\examples{
data("starwars", package = "dplyr")
# show summary statistics for starwars
inspect_num(starwars)
# with a visualisation too - try to limit number of bins
inspect_num(starwars, breaks = 10)
# compare two data frames
inspect_num(starwars, starwars[-c(1:10), ], breaks = 10, show_plot = TRUE)
}
