% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data.R
\name{get_data}
\alias{get_data}
\alias{get_data.default}
\alias{get_data.glmmTMB}
\alias{get_data.afex_aov}
\alias{get_data.rma}
\title{Get the data that was used to fit the model}
\usage{
get_data(x, ...)

\method{get_data}{default}(x, source = "environment", verbose = TRUE, ...)

\method{get_data}{glmmTMB}(
  x,
  effects = "all",
  component = "all",
  source = "environment",
  verbose = TRUE,
  ...
)

\method{get_data}{afex_aov}(x, shape = c("long", "wide"), ...)

\method{get_data}{rma}(
  x,
  source = "environment",
  verbose = TRUE,
  include_interval = FALSE,
  transf = NULL,
  transf_args = NULL,
  ci = 0.95,
  ...
)
}
\arguments{
\item{x}{A fitted model.}

\item{...}{Currently not used.}

\item{source}{String, indicating from where data should be recovered. If
\code{source = "environment"} (default), data is recovered from the environment
(e.g. if the data is in the workspace). This option is usually the fastest
way of getting data and ensures that the original variables used for model
fitting are returned. Note that always the \emph{current} data is recovered from
the environment. Hence, if the data was modified \emph{after} model fitting
(e.g., variables were recoded or rows filtered), the returned data may no
longer equal the model data. If \code{source = "frame"} (or \code{"mf"}), the data
is taken from the model frame. Any transformed variables are back-transformed,
if possible. This option returns the data even if it is not available in
the environment, however, in certain edge cases back-transforming to the
original data may fail. If \code{source = "environment"} fails to recover the
data, it tries to extract the data from the model frame; if
\code{source = "frame"} and data cannot be extracted from the model frame, data
will be recovered from the environment. Both ways only returns observations
that have no missing data in the variables used for model fitting.}

\item{verbose}{Toggle messages and warnings.}

\item{effects}{Should model data for fixed effects (\code{"fixed"}), random
effects (\code{"random"}) or both (\code{"all"}) be returned? Only applies to mixed
or gee models.}

\item{component}{Should all predictor variables, predictor variables for the
conditional model, the zero-inflated part of the model, the dispersion
term or the instrumental variables be returned? Applies to models
with zero-inflated and/or dispersion formula, or to models with instrumental
variable (so called fixed-effects regressions). May be abbreviated. Note that the
\emph{conditional} component is also called \emph{count} or \emph{mean}
component, depending on the model.}

\item{shape}{Return long or wide data? Only applicable in repeated measures
designs.}

\item{include_interval}{For meta-analysis models, should normal-approximation
confidence intervals be added for each response effect size?}

\item{transf}{For meta-analysis models, if intervals are included, a function
applied to each response effect size and its interval.}

\item{transf_args}{For meta-analysis models, an optional list of arguments
passed to the \code{transf} function.}

\item{ci}{For meta-analysis models, the Confidence Interval (CI) level if
\code{include_interval = TRUE}. Default to 0.95 (95\%).}
}
\value{
The data that was used to fit the model.
}
\description{
This functions tries to get the data that was used to fit the
model and returns it as data frame.
}
\section{Model components}{

Possible values for the \code{component} argument depend on the model class.
Following are valid options:
\itemize{
\item \code{"all"}: returns all model components, applies to all models, but will only
have an effect for models with more than just the conditional model component.
\item \code{"conditional"}: only returns the conditional component, i.e. "fixed effects"
terms from the model. Will only have an effect for models with more than
just the conditional model component.
\item \code{"smooth_terms"}: returns smooth terms, only applies to GAMs (or similar
models that may contain smooth terms).
\item \code{"zero_inflated"} (or \code{"zi"}): returns the zero-inflation component.
\item \code{"dispersion"}: returns the dispersion model component. This is common
for models with zero-inflation or that can model the dispersion parameter.
\item \code{"instruments"}: for instrumental-variable or some fixed effects regression,
returns the instruments.
\item \code{"location"}: returns location parameters such as \code{conditional},
\code{zero_inflated}, \code{smooth_terms}, or \code{instruments} (everything that are
fixed or random effects - depending on the \code{effects} argument - but no
auxiliary parameters).
\item \code{"distributional"} (or \code{"auxiliary"}): components like \code{sigma}, \code{dispersion},
\code{beta} or \code{precision} (and other auxiliary parameters) are returned.
}
}

\examples{
if (require("lme4")) {
  data(cbpp, package = "lme4")
  cbpp$trials <- cbpp$size - cbpp$incidence
  m <- glm(cbind(incidence, trials) ~ period, data = cbpp, family = binomial)
  head(get_data(m))
}
}
