% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/n_grouplevels.R
\name{n_grouplevels}
\alias{n_grouplevels}
\title{Count number of random effect levels in a mixed model}
\usage{
n_grouplevels(x, ...)
}
\arguments{
\item{x}{A mixed model.}

\item{...}{Additional arguments that can be passed to the function. Currently,
you can use \code{data} to provide the model data, if available, to avoid
retrieving model data multiple times.}
}
\value{
The number of group levels in the model.
}
\description{
Returns the number of group levels of random effects from mixed models.
}
\examples{
if (require("lme4")) {
  data(sleepstudy)
  set.seed(12345)
  sleepstudy$grp <- sample(1:5, size = 180, replace = TRUE)
  sleepstudy$subgrp <- NA
  for (i in 1:5) {
    filter_group <- sleepstudy$grp == i
    sleepstudy$subgrp[filter_group] <-
      sample(1:30, size = sum(filter_group), replace = TRUE)
  }
  model <- lmer(
    Reaction ~ Days + (1 | grp / subgrp) + (1 | Subject),
    data = sleepstudy
  )
  n_grouplevels(model)
}
}
