% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{whale_taxonomy}
\alias{whale_taxonomy}
\title{Cetacean section of NCBI taxonomy database.}
\format{A data.frame object with 72 rows and four columns, labeled as follows:
\describe{
  \item{taxID}{the NCBI unique taxon identifier (integer).}
  \item{parent_taxID}{the NCBI unique taxon identifier
    of the immediate parent taxon (integer).}
  \item{rank}{The taxonomic rank (i.e. species, genus, etc; character).}
  \item{name}{The scientific name of the taxon (character).}
}
The database was accessed from
\url{ftp://ftp.ncbi.nlm.nih.gov/pub/taxonomy/taxdump.tar.gz} on 17 June 2018
using the \code{\link{taxonomy}} function, and pruned using
\code{\link{prune_taxonomy}} with
\code{taxIDs = as.integer(gsub(".+\\|", "", names(whales)))}.}
\source{
\url{https://www.ncbi.nlm.nih.gov/taxonomy/}
}
\usage{
whale_taxonomy
}
\description{
A copy of the NCBI taxonomy reference database, subsetted to include only the
  cetacean taxa in the \code{\link{whales}} dataset.
}
\keyword{datasets}
