% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InterpretingMethod.R
\name{InterpretingMethod}
\alias{InterpretingMethod}
\title{Super class for Interpreting Methods}
\description{
This is a super class for all data-based interpreting methods.
Implemented are the following methods:
\itemize{
\item Deep Learning Important Features (\link{DeepLift})
\item Layer-wise Relevance Propagation (\link{LRP})
\item Gradient-based methods:
\itemize{
\item Vanilla gradients including 'Gradients x Input' (\link{Gradient})
\item Smoothed gradients including 'SmoothGrad x Input' (\link{SmoothGrad})
}
}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{data}}{The passed data as a torch tensor in the given data type
(\code{dtype}) to be interpreted with the selected method.}

\item{\code{converter}}{An instance of the R6 class \code{\link{Converter}}.}

\item{\code{dtype}}{The data type for the calculations. Either \code{'float'}
for \link[torch:torch_dtype]{torch::torch_float} or \code{'double'} for \link[torch:torch_dtype]{torch::torch_double}.}

\item{\code{channels_first}}{The format of the given date, i.e. channels on
last dimension (\code{FALSE}) or after the batch dimension (\code{TRUE}). If the
data has no channels, the default value \code{TRUE} is used.}

\item{\code{ignore_last_act}}{A boolean value to include the last
activation into all the calculations, or not (default: \code{TRUE}). In some
cases, the last activation leads to a saturation problem.}

\item{\code{result}}{The methods result of the given data as a
torch tensor of size \emph{(batch_size, dim_in, dim_out)} in the given data type
(\code{dtype}).}

\item{\code{output_idx}}{This vector determines for which outputs the method
will be applied. By default (\code{NULL}), all outputs (but limited to the
first 10) are considered.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-InterpretingMethod-new}{\code{InterpretingMethod$new()}}
\item \href{#method-InterpretingMethod-get_result}{\code{InterpretingMethod$get_result()}}
\item \href{#method-InterpretingMethod-clone}{\code{InterpretingMethod$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InterpretingMethod-new"></a>}}
\if{latex}{\out{\hypertarget{method-InterpretingMethod-new}{}}}
\subsection{Method \code{new()}}{
Create a new instance of this super class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InterpretingMethod$new(
  converter,
  data,
  channels_first = TRUE,
  output_idx = NULL,
  ignore_last_act = TRUE,
  dtype = "float"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{converter}}{An instance of the R6 class \code{\link{Converter}}.}

\item{\code{data}}{The data for which this method is to be applied. It has
to be an array or array-like format of size \emph{(batch_size, dim_in)}.}

\item{\code{channels_first}}{The format of the given data, i.e. channels on
last dimension (\code{FALSE}) or after the batch dimension (\code{TRUE}). If the
data has no channels, use the default value \code{TRUE}.}

\item{\code{output_idx}}{This vector determines for which output indices the
method will be applied. By default (\code{NULL}), all outputs (but limited to
the first 10) are considered.}

\item{\code{ignore_last_act}}{A boolean value to include the last
activation into all the calculations, or not (default: \code{TRUE}). In
some cases, the last activation leads to a saturation problem.}

\item{\code{dtype}}{dtype The data type for the calculations. Use
either \code{'float'} for \link[torch:torch_dtype]{torch::torch_float} or \code{'double'} for
\link[torch:torch_dtype]{torch::torch_double}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InterpretingMethod-get_result"></a>}}
\if{latex}{\out{\hypertarget{method-InterpretingMethod-get_result}{}}}
\subsection{Method \code{get_result()}}{
This function returns the result of this method for the given data
either as an array (\code{'array'}), a torch tensor (\code{'torch.tensor'},
or \code{'torch_tensor'}) of size \emph{(batch_size, dim_in, dim_out)} or as a
data.frame (\code{'data.frame'}).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InterpretingMethod$get_result(type = "array")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{The data type of the result. Use one of \code{'array'},
\code{'torch.tensor'}, \code{'torch_tensor'} or \code{'data.frame'}
(default: \code{'array'}).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The result of this method for the given data in the chosen
type.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InterpretingMethod-clone"></a>}}
\if{latex}{\out{\hypertarget{method-InterpretingMethod-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InterpretingMethod$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
