% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgl.R
\name{glplot.inla.mesh}
\alias{glplot.inla.mesh}
\title{Visualize SpatialPoints using RGL}
\usage{
\method{glplot}{inla.mesh}(object, add = TRUE, col = NULL, ...)
}
\arguments{
\item{object}{an inla.mesh object.}

\item{add}{If TRUE, add the lines to an existing plot. If FALSE, create new plot.}

\item{col}{Color specification. A single named color, a vector of scalar values, or a matrix of RGB values.}

\item{...}{Parameters passed on to plot.inla.mesh()}
}
\description{
This function transforms the mesh to 3D cartesian coordinates and uses
inla.plot.mesh() with \code{rgl=TRUE} to plot the result.
}
\examples{
\dontrun{
if (bru_safe_inla() &&
  require("rgl", quietly = TRUE) &&
  require("sphereplot", quietly = TRUE) &&
  bru_safe_sp()) {

  # Load pantropoical dolphin data

  data("mexdolphin", package = "inlabru")

  # Show the globe

  globe()

  # Add mesh, ship transects and dolphin sightings stored
  # as inla.mesh, SpatialLines and SpatialPoints objects, respectively

  glplot(mexdolphin$mesh)
  glplot(mexdolphin$samplers)
  glplot(mexdolphin$points)
}
}
}
\seealso{
Other inlabru RGL tools: 
\code{\link{globe}()},
\code{\link{glplot.SpatialLines}()},
\code{\link{glplot.SpatialPoints}()},
\code{\link{glplot}()}
}
\concept{inlabru RGL tools}
