% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmesher_evaluator.R
\name{fm_evaluate}
\alias{fm_evaluate}
\alias{fm_evaluate.inla.mesh}
\alias{fm_evaluate.inla.mesh.1d}
\alias{fm_evaluate.fm_evaluator}
\alias{fm_evaluator}
\alias{fm_evaluator_inla_mesh}
\alias{fm_evaluator_inla_mesh_1d}
\alias{fm_evaluator_lattice}
\alias{fm_evaluator.inla.mesh}
\alias{fm_evaluator.inla.mesh.1d}
\title{Methods for projecting to/from an inla.mesh}
\usage{
fm_evaluate(...)

\method{fm_evaluate}{inla.mesh}(mesh, field, ...)

\method{fm_evaluate}{inla.mesh.1d}(mesh, field, ...)

\method{fm_evaluate}{fm_evaluator}(projector, field, ...)

fm_evaluator(...)

fm_evaluator_inla_mesh(mesh, loc = NULL, crs = NULL, ...)

fm_evaluator_inla_mesh_1d(mesh, loc, ...)

fm_evaluator_lattice(
  mesh,
  xlim = NULL,
  ylim = NULL,
  dims = c(100, 100),
  projection = NULL,
  crs = NULL,
  ...
)

\method{fm_evaluator}{inla.mesh}(mesh, loc = NULL, lattice = NULL, crs = NULL, ...)

\method{fm_evaluator}{inla.mesh.1d}(mesh, loc = NULL, xlim = mesh$interval, dims = 100, ...)
}
\arguments{
\item{\dots}{Additional arguments passed on to methods.}

\item{mesh}{An \code{inla.mesh} or \code{inla.mesh.1d} object.}

\item{field}{Basis function weights, one per mesh basis function, describing
the function to be evaluated at the projection locations}

\item{projector}{An \code{fm_evaluator} object.}

\item{loc}{Projection locations.  Can be a matrix, \code{SpatialPoints},
\code{SpatialPointsDataFrame}, \code{sf}, \code{sfc}, or \code{sfg} object.}

\item{crs}{An optional CRS or inla.CRS object associated with \code{loc}
and/or \code{lattice}.}

\item{xlim}{X-axis limits for a lattice. For R2 meshes, defaults to covering
the domain.}

\item{ylim}{Y-axis limits for a lattice. For R2 meshes, defaults to covering
the domain.}

\item{dims}{Lattice dimensions.}

\item{projection}{One of \code{c("default", "longlat", "longsinlat", "mollweide")}.}

\item{lattice}{An \code{inla.mesh.lattice()} object.}
}
\value{
For \code{fm_evaluate(mesh, ...)}, a list with projection
information.  For \code{fm_evaluator(mesh, ...)}, an
\code{fm_evaluator} object.  For \code{fm_evaluate(projector, field, ...)}, a field projected from the mesh onto the locations given by
the projector object.
}
\description{
Calculate a lattice projection to/from an \code{inla.mesh}
}
\section{Functions}{
\itemize{
\item \code{fm_evaluator(inla.mesh)}: The \code{...} arguments are passed on to \code{fm_evaluator_lattice()}
if no \code{loc} or \code{lattice} is provided.

}}
\examples{
if (bru_safe_inla()) {
  n <- 20
  loc <- matrix(runif(n * 2), n, 2)
  mesh <- INLA::inla.mesh.create(loc, refine = list(max.edge = 0.05))
  proj <- fm_evaluator(mesh)
  field <- cos(mesh$loc[, 1] * 2 * pi * 3) * sin(mesh$loc[, 2] * 2 * pi * 7)
  image(proj$x, proj$y, fm_evaluate(proj, field))
}
\donttest{
if (bru_safe_inla() &&
  require(rgl)) {
  plot(mesh, rgl = TRUE, col = field, draw.edges = FALSE, draw.vertices = FALSE)
}
}
}
\seealso{
\code{inla.mesh}, \code{inla.mesh.1d},
\code{inla.mesh.lattice}
}
\author{
Finn Lindgren \email{finn.lindgren@gmail.com}
}
