% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mappers.R
\name{bru_mapper_marginal}
\alias{bru_mapper_marginal}
\alias{ibm_n.bru_mapper_marginal}
\alias{ibm_n_output.bru_mapper_marginal}
\alias{ibm_values.bru_mapper_marginal}
\alias{ibm_jacobian.bru_mapper_marginal}
\alias{ibm_eval.bru_mapper_marginal}
\title{Mapper for marginal distribution transformation}
\usage{
bru_mapper_marginal(
  qfun,
  pfun = NULL,
  dfun = NULL,
  dqfun = NULL,
  ...,
  inverse = FALSE
)

\method{ibm_n}{bru_mapper_marginal}(mapper, ..., state = NULL, n_state = NULL)

\method{ibm_n_output}{bru_mapper_marginal}(mapper, input, state = NULL, ..., n_state = NULL)

\method{ibm_values}{bru_mapper_marginal}(mapper, ..., state = NULL, n_state = NULL)

\method{ibm_jacobian}{bru_mapper_marginal}(mapper, input, state = NULL, ..., reverse = FALSE)

\method{ibm_eval}{bru_mapper_marginal}(mapper, input, state = NULL, ..., reverse = FALSE)
}
\arguments{
\item{qfun}{A quantile function, supporting \code{lower.tail} and \code{log.p}
arguments, like \code{\link[stats:Normal]{stats::qnorm()}}.}

\item{pfun}{A CDF, supporting \code{lower.tail} and \code{log.p} arguments,
like \code{\link[stats:Normal]{stats::pnorm()}}.  Only needed and used when
\code{xor(mapper[["inverse"]], reverse)} is \code{TRUE} in a method call.
Default \code{NULL}}

\item{dfun}{A pdf, supporting \code{log} argument,
like \code{\link[stats:Normal]{stats::dnorm()}}. If \code{NULL} (default), uses finite
differences on \code{qfun} or \code{pfun} instead.}

\item{dqfun}{A function evaluating the reciprocal of the derivative of
\code{qfun}. If \code{NULL} (default), uses \code{dfun(qfun(...),...)} or finite
differences on \code{qfun} or \code{pfun} instead.}

\item{...}{Arguments passed on to other methods}

\item{inverse}{logical; If \code{FALSE} (default), \code{\link[=bru_mapper_marginal]{bru_mapper_marginal()}}
defines a mapping from standard Normal to a specified distribution.
If \code{TRUE}, it defines a mapping from the specified distribution to a standard
Normal.}

\item{mapper}{A mapper S3 object, inheriting from \code{bru_mapper}.}

\item{state}{A vector of latent state values for the mapping,
of length \code{ibm_n(mapper, inla_f = FALSE)}}

\item{n_state}{integer giving the length of the state vector for mappers
that have state dependent output size.}

\item{input}{Data input for the mapper.}

\item{reverse}{logical; control \code{bru_mapper_marginal} evaluation. Default
\code{FALSE}. When \code{TRUE}, reverses the direction of the mapping, see details
for \code{marginal} mappers.}
}
\description{
Constructs a mapper that transforms the marginal distribution \code{state} from
\eqn{\textrm{N}(0,1)}{N(0, 1)} to the distribution of a given (continuous)
quantile function. The \code{...} arguments are used as parameter arguments to
\code{qfun}, \code{pfun}, \code{dfun}, and \code{dqfun}.
}
\section{Methods (by generic)}{
\itemize{
\item \code{ibm_jacobian(bru_mapper_marginal)}: Non-NULL \code{input} values are interpreted
as a parameter list for \code{qfun}, overriding that of the mapper itself.

\item \code{ibm_eval(bru_mapper_marginal)}: When \code{xor(mapper[["inverse"]], reverse)} is
\code{FALSE}, \code{ibm_eval()}
for \code{marginal} returns \code{qfun(pnorm(x), param)}, evaluated in a numerically
stable way. Otherwise, evaluates the inverse \code{qnorm(pfun(x, param))} instead.

}}
\examples{
m <- bru_mapper_marginal(qexp, pexp, rate = 1 / 8)
(val <- ibm_eval(m, state = -5:5))
ibm_eval(m, state = val, reverse = TRUE)
m <- bru_mapper_marginal(qexp, pexp, dexp, rate = 1 / 8)
ibm_eval2(m, state = -3:3)

}
\seealso{
\link{bru_mapper}, \link{bru_mapper_generics}

Other mappers: 
\code{\link{bru_get_mapper}()},
\code{\link{bru_mapper}()},
\code{\link{bru_mapper.fm_mesh_1d}()},
\code{\link{bru_mapper.fm_mesh_2d}()},
\code{\link{bru_mapper_aggregate}()},
\code{\link{bru_mapper_collect}()},
\code{\link{bru_mapper_const}()},
\code{\link{bru_mapper_factor}()},
\code{\link{bru_mapper_fmesher}()},
\code{\link{bru_mapper_generics}},
\code{\link{bru_mapper_harmonics}()},
\code{\link{bru_mapper_index}()},
\code{\link{bru_mapper_linear}()},
\code{\link{bru_mapper_logsumexp}()},
\code{\link{bru_mapper_matrix}()},
\code{\link{bru_mapper_mesh_B}()},
\code{\link{bru_mapper_multi}()},
\code{\link{bru_mapper_pipe}()},
\code{\link{bru_mapper_repeat}()},
\code{\link{bru_mapper_scale}()},
\code{\link{bru_mapper_shift}()},
\code{\link{bru_mapper_taylor}()}
}
\concept{mappers}
