% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mappers.R
\name{bru_mapper_harmonics}
\alias{bru_mapper_harmonics}
\alias{ibm_n.bru_mapper_harmonics}
\alias{ibm_jacobian.bru_mapper_harmonics}
\title{Mapper for cos/sin functions}
\usage{
bru_mapper_harmonics(
  order = 1,
  scaling = 1,
  intercept = TRUE,
  interval = c(0, 1)
)

\method{ibm_n}{bru_mapper_harmonics}(mapper, inla_f = FALSE, ...)

\method{ibm_jacobian}{bru_mapper_harmonics}(mapper, input, state = NULL, inla_f = FALSE, ...)
}
\arguments{
\item{order}{For \code{bru_mapper_harmonics}, specifies the maximum \code{cos}/\code{sin}
order. (Default 1)}

\item{scaling}{For \code{bru_mapper_harmonics}, specifies an optional vector of
scaling factors of length \code{intercept + order}, or a common single scalar.}

\item{intercept}{logical; For \code{bru_mapper_harmonics}, if \code{TRUE}, the first
basis function is a constant. (Default \code{TRUE})}

\item{interval}{numeric length-2 vector specifying a domain interval.
Default \code{c(0, 1)}.}

\item{mapper}{A mapper S3 object, inheriting from \code{bru_mapper}.}

\item{inla_f}{logical; when \code{TRUE} for \code{ibm_n()} and \code{ibm_values()}, the
result must be compatible with the \code{INLA::f(...)} and corresponding
\code{INLA::inla.stack(...)} constructions.  For \verb{ibm_\{eval,jacobian,linear\}},
the \code{input} interpretation may be different.
Implementations do not normally need to do anything different, except
for mappers of the type needed for hidden multicomponent models such
as "bym2", which can be handled by \code{bru_mapper_collect}.}

\item{...}{Arguments passed on to other methods}

\item{input}{Data input for the mapper.}

\item{state}{A vector of latent state values for the mapping,
of length \code{ibm_n(mapper, inla_f = FALSE)}}
}
\description{
Constructs a mapper for \code{cos}/\code{sin} functions of orders 1 (if
\code{intercept} is \code{TRUE}, otherwise 0) through \code{order}. The total number of
basis functions is \code{intercept + 2 * order}.

Optionally, each order can be given a non-unit scaling, via the \code{scaling}
vector, of length \code{intercept + order}. This can be used to
give an effective spectral prior. For example, let

\if{html}{\out{<div class="sourceCode">}}\preformatted{scaling = 1 / (1 + (0:4)^2)
x <- seq(0, 1, length.out = 11)
bmh1 = bru_mapper_harmonics(order = 4, interval = c(0, 1))
u1 <- ibm_eval(
  bmh1,
  input = x,
  state = rnorm(9, sd = rep(scaling, c(1, 2, 2, 2, 2)))
)
}\if{html}{\out{</div>}}

Then, with

\if{html}{\out{<div class="sourceCode">}}\preformatted{bmh2 = bru_mapper_harmonics(order = 4, scaling = scaling)
u2 = ibm_eval(bmh2, input = x, state = rnorm(9))
}\if{html}{\out{</div>}}

the stochastic properties of \code{u1} and \code{u2} will be the same, with
\code{scaling^2} determining the variance for each frequency contribution.

The period for the first order harmonics is shifted and scaled to match
\code{interval}.
}
\examples{
m <- bru_mapper_harmonics(2)
ibm_eval2(m, input = c(0, pi / 4, pi / 2, 3 * pi / 4), 1:5)

}
\seealso{
\link{bru_mapper}, \link{bru_mapper_generics}

Other mappers: 
\code{\link{bru_get_mapper}()},
\code{\link{bru_mapper}()},
\code{\link{bru_mapper.fm_mesh_1d}()},
\code{\link{bru_mapper.fm_mesh_2d}()},
\code{\link{bru_mapper_aggregate}()},
\code{\link{bru_mapper_collect}()},
\code{\link{bru_mapper_const}()},
\code{\link{bru_mapper_factor}()},
\code{\link{bru_mapper_fmesher}()},
\code{\link{bru_mapper_generics}},
\code{\link{bru_mapper_index}()},
\code{\link{bru_mapper_linear}()},
\code{\link{bru_mapper_logsumexp}()},
\code{\link{bru_mapper_marginal}()},
\code{\link{bru_mapper_matrix}()},
\code{\link{bru_mapper_mesh_B}()},
\code{\link{bru_mapper_multi}()},
\code{\link{bru_mapper_pipe}()},
\code{\link{bru_mapper_repeat}()},
\code{\link{bru_mapper_scale}()},
\code{\link{bru_mapper_shift}()},
\code{\link{bru_mapper_taylor}()}
}
\concept{mappers}
