% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot.R
\name{gg.inla.mesh}
\alias{gg.inla.mesh}
\title{Geom for inla.mesh objects}
\usage{
\method{gg}{inla.mesh}(data, color = NULL, alpha = NULL,
  edge.color = "grey", interior = TRUE, int.color = "blue",
  exterior = TRUE, ext.color = "black", crs = NULL, mask = NULL,
  nx = 500, ny = 500, ...)
}
\arguments{
\item{data}{An \link[INLA]{inla.mesh} object.}

\item{color}{A vector of scalar values to fill the mesh with colors. The length of the vector mus correspond to the number of mesh vertices.}

\item{alpha}{A vector of scalar values setting the alpha value of the colors provided.}

\item{edge.color}{Color of the mesh edges.}

\item{interior}{If TRUE, plot the interior boundaries of the mesh.}

\item{int.color}{Color used to plot the interior boundaries.}

\item{exterior}{If TRUE, plot the exterior boundaries of the mesh.}

\item{ext.color}{Color used to plot the interior boundaries.}

\item{crs}{A \link{CRS} object defining the coordinate system to project the mesh to before plotting.}

\item{mask}{A SpatialPolygon defining the region that is plotted.}

\item{nx}{Number of pixels in x direction (when plotting using the color parameter).}

\item{ny}{Number of pixels in y direction (when plotting using the color parameter).}

\item{...}{ignored arguments (S3 generic compatibility).}
}
\value{
\link{geom_line} return values or, if the color argument is used, the values of gg.SpatialPixelDataFrame().
}
\description{
This function extracts the graph of an inla.mesh object and uses \link{geom_line} to visualize
the graph's edges. Alternatively, if the \code{color} argument is provided, interpolates the colors
across for a set of SpatialPixels covering the mesh area and calls gg.SpatialPixelDataFrame()
to plot the interpolation.
}
\examples{
\donttest{
# Load Gorilla data
data("gorillas", package = "inlabru")

# Plot mesh using default edge colors

ggplot() + gg(gorillas$mesh)

# Don't show interior and exterior boundaries

ggplot() + gg(gorillas$mesh, interior = FALSE, exterior = FALSE)

# Change the edge colors

ggplot() + gg(gorillas$mesh, 
              edge.color = "green",
              int.color = "black",
              ext.color = "blue"
              )

# Use the x-coordinate of the vertices to colorize the triangles and
# mask the plotted area by the survey boundary, i.e. only plot the inside

xcoord = gorillas$mesh$loc[,1]
ggplot() + 
  gg(gorillas$mesh, color = (xcoord-580), mask = gorillas$boundary) +
  gg(gorillas$boundary)
}
}
\seealso{
Other geomes for meshes: \code{\link{gg.inla.mesh.1d}},
  \code{\link{gg}}, \code{\link{gm}}
}
