% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_oscillations.R
\name{calculate_oscillations}
\alias{calculate_oscillations}
\title{Calculate Oscillations for Ceteris Paribus Explainer}
\usage{
calculate_oscillations(x, sort = TRUE, ...)
}
\arguments{
\item{x}{a ceteris paribus explainer produced with the \code{ceteris_paribus()} function}

\item{sort}{a logical value. If \code{TRUE} then rows are sorted along the oscillations}

\item{...}{other arguments}
}
\value{
an object of the class \code{ceteris_paribus_oscillations}
}
\description{
Oscillations are proxies for local feature importance at the instance level.
Find more details in \href{https://ema.drwhy.ai/ceterisParibusOscillations.html}{Ceteris Paribus Oscillations Chapter}.
}
\examples{
library("DALEX")
library("ingredients")

titanic_small <- select_sample(titanic_imputed, n = 500, seed = 1313)

# build a model
model_titanic_glm <- glm(survived ~ gender + age + fare,
                         data = titanic_small, family = "binomial")

explain_titanic_glm <- explain(model_titanic_glm,
                               data = titanic_small[,-8],
                               y = titanic_small[,8])

cp_rf <- ceteris_paribus(explain_titanic_glm, titanic_small[1,])

calculate_oscillations(cp_rf)

\donttest{
library("ranger")

apartments_rf_model <- ranger(m2.price ~ construction.year + surface + floor +
                                    no.rooms + district, data = apartments)

explainer_rf <- explain(apartments_rf_model,
                        data = apartments_test[,-1],
                        y = apartments_test$m2.price,
                        label = "ranger forest",
                        verbose = FALSE)

apartment <- apartments_test[1,]

cp_rf <- ceteris_paribus(explainer_rf, apartment)

calculate_oscillations(cp_rf)
}

}
\references{
Explanatory Model Analysis. Explore, Explain, and Examine Predictive Models. \url{https://ema.drwhy.ai/}
}
