% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getFixedEF.onePhase.R
\name{getFixedEF.onePhase}
\alias{getFixedEF.onePhase}
\title{Get the Fixed Components' coefficients and Efficiency Factors of
Single-Phase Experiments.}
\usage{
getFixedEF.onePhase(effFactors, trt.Sca, T, Rep, table.legend, decimal, digits,
  list.sep)
}
\arguments{
\item{effFactors}{a list of numeric vector generated by
\code{\link{getEffFactor}} function.}

\item{trt.Sca}{a numeric vector generated by \code{\link{getTrtRep}}
function.}

\item{T}{a list of matrices generated by \code{\link{makeContrMat}}
function.}

\item{Rep}{a numeric matrix generated by \code{\link{getTrtRep}} function.}

\item{table.legend}{a logical allows users to generate a legend for the
variance components of the ANOVA table for large designs. Default is
\code{FALSE}, resulting in the use of original treatment factor names.}

\item{decimal}{a logical allows users to display the coefficients as the
decimals. Default is \code{FALSE}, resulting in the use of
\code{fractions}.}

\item{digits}{a integer indicating the number of decimal places. Default is
2, resulting in 2 decimal places.}

\item{list.sep}{a logical allows users to present the efficiency factors
and coefficients of the fixed effects a list of separate matrices.}
}
\value{
A matrix.
}
\description{
Calculate coefficients of fixed effects components of EMS and Treatment
Efficiency Factors within each stratum in Single-Phase or two-phase
experiment.
}
\details{
Constructs a matrix containing the coefficients of the coefficients of
fixed effects components of EMS within each stratum. Also calculates and
the average efficiency factors of each treatment effect across all strata

Construct a matrix contain the coefficients of the fixed Components and the
average efficiency factors of single-phase experiments.

The function uses the efficiency factors generated by \code{getEffFactor}
to calculated the coefficients of fixed Effects components of EMS and
insert the treatment efficiency factor within each stratum.

The complication arise in giving the row names of the matrix for the source
of variation in the ANOVA table.
}
\examples{

design1 <- local({ 
  Ani = as.factor(LETTERS[c(1,2,3,4,
                            5,6,7,8)])
  Trt = as.factor(letters[c(1,1,1,1,
                            2,2,2,2)])
  data.frame(Ani, Trt)
})

blk.str <- "Ani"
    
rT <- terms(as.formula(paste("~", blk.str, sep = "")), keep.order = TRUE) 
blkTerm = attr(rT,"term.labels")
     
Z <- makeBlkDesMat(design1, blkTerm)

trt.str <- "Trt"              
fT <- terms(as.formula(paste("~", trt.str, sep = "")), keep.order = TRUE)  #fixed terms

trtTerm <- attr(fT, "term.labels")
effectsMatrix <- attr(fT, "factor")        

T <- makeContrMat(design1, trtTerm, effectsMatrix, contr.vec = NA)

N <- makeOverDesMat(design1, trtTerm)
		
Replist = getTrtRep(design1, trtTerm)   
 
Rep <- Replist$Rep
trt.Sca <- Replist$Sca
    
effFactors = lapply(makeOrthProjectors(Z), function(z) getEffFactor(z, T, N, Rep, trt.Sca))


effFactors <- effFactors[sort(1:length(effFactors), decreasing=TRUE)]

getFixedEF.onePhase(effFactors = effFactors, trt.Sca = trt.Sca,  T = T, Rep = Rep, 
			table.legend = FALSE, decimal = FALSE, digits = 2, list.sep = TRUE)

}
\author{
Kevin Chang
}
