% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/influxdb_schema_exploration.R
\name{influx_schema_exploration_helpers}
\alias{influx_schema_exploration_helpers}
\alias{show_databases}
\alias{show_measurements}
\alias{show_series}
\alias{show_tag_keys}
\alias{show_tag_values}
\alias{show_field_keys}
\alias{show_retention_policies}
\title{Influx schema exploration}
\usage{
show_databases(con)

show_measurements(con, db, where = NULL)

show_series(con, db, measurement = NULL, where = NULL)

show_tag_keys(con, db, measurement = NULL)

show_tag_values(con, db, measurement = NULL, key)

show_field_keys(con, db, measurement = NULL)

show_retention_policies(con, db)
}
\arguments{
\item{con}{An \code{influx_connection} object (s. \code{\link{influx_connection}}).}

\item{db}{Sets the target database for the query.}

\item{where}{Apply filter on tag key values.}

\item{measurement}{Query a specific measurement.}

\item{key}{The key to be queried.}
}
\value{
A tibble containing query results.
}
\description{
The folllowing functions are convenient wrappers around \code{influx_query}.
\itemize{
\item \code{show_databases()}: returns database names
\item \code{show_measurements()}: returns measurement names
\item \code{show_series()}: returns unambiguous series
\item \code{show_tag_keys()}: returns tag keys
\item \code{show_tag_values()}: returns tag values
\item \code{show_field_keys()}: returns field keys
\item \code{show_retentions_policies()}: returns retention policies
}
}
\references{
\url{https://docs.influxdata.com/influxdb/}
}
\seealso{
\code{\link[influxdbr]{influx_connection}}
}
